/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.dataSource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.noear.solon.data.sqlink.base.dataSource.DataSourceManager;

public class DefaultDataSourceManager
implements DataSourceManager {
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private final ThreadLocal<String> dsKey = new ThreadLocal();
    private static final String Default = "default";

    public DefaultDataSourceManager(DataSource defluteDataSource) {
        this.dataSourceMap.put(Default, defluteDataSource);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public DataSource getDataSource() {
        String key = this.getDsKey();
        if (key == null) {
            return this.getDataSource(Default);
        }
        return this.getDataSource(key);
    }

    private DataSource getDataSource(String key) {
        DataSource dataSource = this.dataSourceMap.get(key);
        if (dataSource == null) {
            throw new RuntimeException("No DataSource found for key: " + key);
        }
        return dataSource;
    }

    @Override
    public void useDs(String key) {
        this.dsKey.set(key);
    }

    @Override
    public void useDefDs() {
        this.dsKey.remove();
    }

    @Override
    public String getDsKey() {
        return this.dsKey.get();
    }
}

