/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.solon;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.api.yaml.YamlShardingSphereDataSourceFactory;
import org.noear.solon.Utils;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.ResourceUtil;

public class ShardingSphereSupplier
implements Supplier<DataSource> {
    private final Properties properties;

    public ShardingSphereSupplier(Properties properties) {
        this.properties = properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataSource get() {
        try {
            String fileUri = this.properties.getProperty("file");
            if (!Utils.isNotEmpty((String)fileUri)) {
                String configTxt = this.properties.getProperty("config");
                if (!Utils.isNotEmpty((String)configTxt)) throw new IllegalStateException("Invalid sharding sphere configuration");
                return YamlShardingSphereDataSourceFactory.createDataSource((byte[])configTxt.getBytes());
            }
            URL resource = ResourceUtil.findResource((String)fileUri);
            if (resource == null) {
                throw new IllegalStateException("The sharding sphere configuration file does not exist");
            }
            try (InputStream in = resource.openStream();){
                byte[] bytes = IoUtil.transferToBytes((InputStream)in);
                DataSource dataSource = YamlShardingSphereDataSourceFactory.createDataSource((byte[])bytes);
                return dataSource;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("The sharding sphere configuration failed", e);
        }
    }
}

