/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.rx.sql.impl;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.Solon;
import org.noear.solon.data.rx.sql.bound.RxRowConverter;
import org.noear.solon.data.rx.sql.bound.RxRowConverterFactory;

public class DefaultRxConverter
implements RxRowConverterFactory<Object> {
    private static RxRowConverterFactory instance = new DefaultRxConverter();

    public static RxRowConverterFactory getInstance() {
        return instance;
    }

    public static void setInstance(RxRowConverterFactory instance) {
        if (instance != null) {
            DefaultRxConverter.instance = instance;
        }
    }

    @Override
    public RxRowConverter<Object> create(Class<?> tClass) {
        return new RowConverterImpl(tClass);
    }

    static {
        if (Solon.app() != null) {
            Solon.context().getBeanAsync(RxRowConverterFactory.class, bean -> {
                instance = bean;
            });
        }
    }

    private static class RowConverterImpl
    implements RxRowConverter<Object> {
        private final Class<?> tClass;

        public RowConverterImpl(Class<?> tClass) {
            this.tClass = tClass;
        }

        @Override
        public Object convert(Row row, RowMetadata metaData) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (int i = 0; i < metaData.getColumnMetadatas().size(); ++i) {
                String name = metaData.getColumnMetadata(i).getName();
                Object value = row.get(i);
                map.put(name, value);
            }
            if (Map.class == this.tClass) {
                return map;
            }
            return ONode.ofBean(map, (Feature[])new Feature[0]).toBean(this.tClass);
        }
    }
}

