/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.rx.sql;

import io.r2dbc.spi.Statement;
import java.util.Collection;
import org.noear.solon.data.rx.sql.bound.RxStatementBinder;

public class RxSqlCommand<T> {
    private RxStatementBinder<T> binder;
    private String sql;
    private T args;
    private Collection<T> argsColl;

    public RxSqlCommand(String sql, T args, RxStatementBinder<T> binder) {
        this.sql = sql;
        this.args = args;
        this.argsColl = null;
        this.binder = binder;
    }

    public RxSqlCommand(String sql, Collection<T> argsColl, RxStatementBinder<T> binder) {
        this.sql = sql;
        this.args = null;
        this.argsColl = argsColl;
        this.binder = binder;
    }

    public boolean isBatch() {
        return this.argsColl != null;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void setArgs(T args) {
        this.argsColl = null;
        this.args = args;
    }

    public T getArgs() {
        return this.args;
    }

    public void setArgsColl(Collection<T> argsColl) {
        this.argsColl = argsColl;
        this.args = null;
    }

    public Collection<T> getArgsColl() {
        return this.argsColl;
    }

    public RxStatementBinder<T> getBinder() {
        return this.binder;
    }

    public void fill(Statement stmt) {
        if (this.argsColl == null) {
            this.binder.setValues(stmt, this.args);
        } else {
            int count = 0;
            for (T row : this.argsColl) {
                if (count > 0) {
                    stmt.add();
                }
                this.binder.setValues(stmt, row);
                ++count;
            }
        }
    }

    public String toString() {
        return this.sql;
    }
}

