/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.configurationprocessor.metadata;

import java.util.Locale;
import org.noear.solon.configurationprocessor.metadata.ItemDeprecation;

public final class ItemMetadata
implements Comparable<ItemMetadata> {
    private final ItemType itemType;
    private String name;
    private String type;
    private String description;
    private String sourceType;
    private String sourceMethod;
    private Object defaultValue;
    private ItemDeprecation deprecation;

    ItemMetadata(ItemType itemType, String prefix, String name, String type, String sourceType, String sourceMethod, String description, Object defaultValue, ItemDeprecation deprecation) {
        this.itemType = itemType;
        this.name = this.buildName(prefix, name);
        this.type = type;
        this.sourceType = sourceType;
        this.sourceMethod = sourceMethod;
        this.description = description;
        this.defaultValue = defaultValue;
        this.deprecation = deprecation;
    }

    public static ItemMetadata newGroup(String name, String type, String sourceType, String sourceMethod) {
        return new ItemMetadata(ItemType.GROUP, name, null, type, sourceType, sourceMethod, null, null, null);
    }

    public static ItemMetadata newProperty(String prefix, String name, String type, String sourceType, String sourceMethod, String description, Object defaultValue, ItemDeprecation deprecation) {
        return new ItemMetadata(ItemType.PROPERTY, prefix, name, type, sourceType, sourceMethod, description, defaultValue, deprecation);
    }

    public static String newItemMetadataPrefix(String prefix, String suffix) {
        return prefix.toLowerCase(Locale.ENGLISH) + suffix;
    }

    private String buildName(String prefix, String name) {
        StringBuilder fullName = new StringBuilder();
        if (prefix != null) {
            if (prefix.endsWith(".")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            fullName.append(prefix);
        }
        if (name != null) {
            if (fullName.length() > 0) {
                fullName.append('.');
            }
            fullName.append(name);
        }
        return fullName.toString();
    }

    public boolean isOfItemType(ItemType itemType) {
        return this.itemType == itemType;
    }

    public boolean hasSameType(ItemMetadata metadata) {
        return this.itemType == metadata.itemType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceMethod() {
        return this.sourceMethod;
    }

    public void setSourceMethod(String sourceMethod) {
        this.sourceMethod = sourceMethod;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ItemDeprecation getDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(ItemDeprecation deprecation) {
        this.deprecation = deprecation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemMetadata other = (ItemMetadata)o;
        boolean result = true;
        result = result && this.nullSafeEquals((Object)this.itemType, (Object)other.itemType);
        result = result && this.nullSafeEquals(this.name, other.name);
        result = result && this.nullSafeEquals(this.type, other.type);
        result = result && this.nullSafeEquals(this.description, other.description);
        result = result && this.nullSafeEquals(this.sourceType, other.sourceType);
        result = result && this.nullSafeEquals(this.sourceMethod, other.sourceMethod);
        result = result && this.nullSafeEquals(this.defaultValue, other.defaultValue);
        result = result && this.nullSafeEquals(this.deprecation, other.deprecation);
        return result;
    }

    public int hashCode() {
        int result = this.nullSafeHashCode((Object)this.itemType);
        result = 31 * result + this.nullSafeHashCode(this.name);
        result = 31 * result + this.nullSafeHashCode(this.type);
        result = 31 * result + this.nullSafeHashCode(this.description);
        result = 31 * result + this.nullSafeHashCode(this.sourceType);
        result = 31 * result + this.nullSafeHashCode(this.sourceMethod);
        result = 31 * result + this.nullSafeHashCode(this.defaultValue);
        result = 31 * result + this.nullSafeHashCode(this.deprecation);
        return result;
    }

    private boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private int nullSafeHashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(this.name);
        this.buildToStringProperty(string, "type", this.type);
        this.buildToStringProperty(string, "sourceType", this.sourceType);
        this.buildToStringProperty(string, "description", this.description);
        this.buildToStringProperty(string, "defaultValue", this.defaultValue);
        this.buildToStringProperty(string, "deprecation", this.deprecation);
        return string.toString();
    }

    private void buildToStringProperty(StringBuilder string, String property, Object value) {
        if (value != null) {
            string.append(" ").append(property).append(":").append(value);
        }
    }

    @Override
    public int compareTo(ItemMetadata o) {
        return this.getName().compareTo(o.getName());
    }

    public static enum ItemType {
        GROUP,
        PROPERTY;

    }
}

