/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.configurationprocessor;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.noear.solon.configurationprocessor.MetadataCollector;
import org.noear.solon.configurationprocessor.MetadataGenerationEnvironment;
import org.noear.solon.configurationprocessor.MetadataStore;
import org.noear.solon.configurationprocessor.PropertyDescriptor;
import org.noear.solon.configurationprocessor.PropertyDescriptorResolver;
import org.noear.solon.configurationprocessor.TypeUtils;
import org.noear.solon.configurationprocessor.metadata.ConfigurationMetadata;
import org.noear.solon.configurationprocessor.metadata.InvalidConfigurationMetadataException;
import org.noear.solon.configurationprocessor.metadata.ItemMetadata;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"org.noear.solon.annotation.BindProps"})
public class ConfigurationMetadataAnnotationProcessor
extends AbstractProcessor {
    static final String ADDITIONAL_METADATA_LOCATIONS_OPTION = "org.noear.solon.configurationprocessor.additionalMetadataLocations";
    static final String CONFIGURATION_PROPERTIES_ANNOTATION = "org.noear.solon.annotation.BindProps";
    static final String AUTOWIRED_ANNOTATION = "org.noear.solon.annotation.Inject";
    private static final Set<String> SUPPORTED_OPTIONS = Collections.singleton("org.noear.solon.configurationprocessor.additionalMetadataLocations");
    private MetadataStore metadataStore;
    private MetadataCollector metadataCollector;
    private MetadataGenerationEnvironment metadataEnv;

    protected String configurationPropertiesAnnotation() {
        return CONFIGURATION_PROPERTIES_ANNOTATION;
    }

    protected String autowiredAnnotation() {
        return AUTOWIRED_ANNOTATION;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        System.out.println(1);
        this.metadataStore = new MetadataStore(env);
        this.metadataCollector = new MetadataCollector(env, this.metadataStore.readMetadata());
        this.metadataEnv = new MetadataGenerationEnvironment(env, this.configurationPropertiesAnnotation(), this.autowiredAnnotation());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.metadataCollector.processing(roundEnv);
        TypeElement annotationType = this.metadataEnv.getConfigurationPropertiesAnnotationElement();
        if (annotationType != null) {
            for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
                this.processElement(element);
            }
        }
        if (roundEnv.processingOver()) {
            try {
                this.writeMetadata();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to write metadata", ex);
            }
        }
        return false;
    }

    private void processElement(Element element) {
        try {
            AnnotationMirror annotation = this.metadataEnv.getConfigurationPropertiesAnnotation(element);
            if (annotation != null) {
                String prefix = this.getPrefix(annotation);
                if (element instanceof TypeElement) {
                    TypeElement typeElement = (TypeElement)element;
                    this.processAnnotatedTypeElement(prefix, typeElement, new ArrayDeque<TypeElement>());
                } else if (element instanceof ExecutableElement) {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    this.processExecutableElement(prefix, executableElement, new ArrayDeque<TypeElement>());
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing configuration meta-data on " + element, ex);
        }
    }

    private void processAnnotatedTypeElement(String prefix, TypeElement element, Deque<TypeElement> seen) {
        String type = this.metadataEnv.getTypeUtils().getQualifiedName(element);
        this.metadataCollector.add(ItemMetadata.newGroup(prefix, type, type, null));
        this.processTypeElement(prefix, element, null, seen);
    }

    private void processExecutableElement(String prefix, ExecutableElement element, Deque<TypeElement> seen) {
        Element returns;
        if (!element.getModifiers().contains((Object)Modifier.PRIVATE) && TypeKind.VOID != element.getReturnType().getKind() && (returns = this.processingEnv.getTypeUtils().asElement(element.getReturnType())) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)returns;
            ItemMetadata group = ItemMetadata.newGroup(prefix, this.metadataEnv.getTypeUtils().getQualifiedName(returns), this.metadataEnv.getTypeUtils().getQualifiedName(element.getEnclosingElement()), element.toString());
            if (this.metadataCollector.hasSimilarGroup(group)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate @ConfigurationProperties definition for prefix '" + prefix + "'", element);
            } else {
                this.metadataCollector.add(group);
                this.processTypeElement(prefix, typeElement, element, seen);
            }
        }
    }

    private void processTypeElement(String prefix, TypeElement element, ExecutableElement source, Deque<TypeElement> seen) {
        if (!seen.contains(element)) {
            seen.push(element);
            new PropertyDescriptorResolver(this.metadataEnv).resolve(element, source).forEach(descriptor -> {
                this.metadataCollector.add(descriptor.resolveItemMetadata(prefix, this.metadataEnv));
                if (descriptor.isNested(this.metadataEnv)) {
                    TypeElement nestedTypeElement = (TypeElement)this.metadataEnv.getTypeUtils().asElement(descriptor.getType());
                    String nestedPrefix = ConfigurationMetadata.nestedPrefix(prefix, descriptor.getName());
                    this.processTypeElement(nestedPrefix, nestedTypeElement, source, seen);
                }
                if (this.metadataEnv.getTypeUtils().isCollectionOrMap(descriptor.getType())) {
                    this.processCollectionOrMapType(prefix, (PropertyDescriptor)descriptor, source, seen);
                }
            });
            seen.pop();
        }
    }

    private void processCollectionOrMapType(String prefix, PropertyDescriptor descriptor, ExecutableElement source, Deque<TypeElement> seen) {
        TypeMirror type = descriptor.getType();
        if (TypeUtils.isMap(type)) {
            Element elementTypeElement = this.metadataEnv.getTypeUtils().asElement(type);
            if (elementTypeElement instanceof TypeElement) {
                String wildcardPrefix = ConfigurationMetadata.nestedPrefix(prefix, descriptor.getName() + ".*");
                TypeMirror mapValueType = TypeUtils.getMapValueType(type);
                Element element = this.metadataEnv.getTypeUtils().asElement(mapValueType);
                this.processTypeElement(wildcardPrefix, (TypeElement)element, source, seen);
            }
        } else {
            Element elementTypeElement;
            TypeMirror elementType = this.metadataEnv.getTypeUtils().getCollectionElementType(descriptor.getType());
            if (elementType != null && (elementTypeElement = this.metadataEnv.getTypeUtils().asElement(elementType)) instanceof TypeElement) {
                String wildcardPrefix = ConfigurationMetadata.nestedPrefix(prefix, descriptor.getName() + "[*]");
                this.processTypeElement(wildcardPrefix, (TypeElement)elementTypeElement, source, seen);
            }
        }
    }

    private String getPrefix(AnnotationMirror annotation) {
        String prefix = this.metadataEnv.getAnnotationElementStringValue(annotation, "prefix");
        if (prefix != null) {
            return prefix;
        }
        return this.metadataEnv.getAnnotationElementStringValue(annotation, "value");
    }

    protected ConfigurationMetadata writeMetadata() throws Exception {
        ConfigurationMetadata metadata = this.metadataCollector.getMetadata();
        if (!(metadata = this.mergeAdditionalMetadata(metadata)).getItems().isEmpty()) {
            this.metadataStore.writeMetadata(metadata);
            return metadata;
        }
        return null;
    }

    private ConfigurationMetadata mergeAdditionalMetadata(ConfigurationMetadata metadata) {
        try {
            ConfigurationMetadata merged = new ConfigurationMetadata(metadata);
            merged.merge(this.metadataStore.readAdditionalMetadata());
            return merged;
        }
        catch (FileNotFoundException merged) {
        }
        catch (InvalidConfigurationMetadataException ex) {
            this.log(ex.getKind(), ex.getMessage());
        }
        catch (Exception ex) {
            this.logWarning("Unable to merge additional metadata");
            this.logWarning(this.getStackTrace(ex));
        }
        return metadata;
    }

    private String getStackTrace(Exception ex) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)writer, true));
        return writer.toString();
    }

    private void logWarning(String msg) {
        this.log(Diagnostic.Kind.WARNING, msg);
    }

    public void log(Diagnostic.Kind kind, String msg) {
        this.processingEnv.getMessager().printMessage(kind, msg);
    }
}

