/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.configurationprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.noear.solon.configurationprocessor.TypeUtils;
import org.noear.solon.configurationprocessor.fieldvalues.FieldValuesParser;
import org.noear.solon.configurationprocessor.fieldvalues.javac.JavaCompilerFieldValuesParser;

class MetadataGenerationEnvironment {
    private static final String NULLABLE_ANNOTATION = "org.noear.solon.lang.Nullable";
    private static final Set<String> TYPE_EXCLUDES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("com.zaxxer.hikari.IConnectionCustomizer", "groovy.lang.MetaClass", "groovy.text.markup.MarkupTemplateEngine", "java.io.Writer", "java.io.PrintWriter", "java.lang.ClassLoader", "java.util.concurrent.ThreadFactory", "jakarta.jms.XAConnectionFactory", "javax.sql.DataSource", "javax.sql.XADataSource", "org.apache.tomcat.jdbc.pool.PoolConfiguration", "org.apache.tomcat.jdbc.pool.Validator", "org.flywaydb.core.api.callback.FlywayCallback", "org.flywaydb.core.api.resolver.MigrationResolver")));
    private static final Set<String> DEPRECATION_EXCLUDES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.apache.commons.dbcp2.BasicDataSource#getPassword", "org.apache.commons.dbcp2.BasicDataSource#getUsername")));
    private final TypeUtils typeUtils;
    private final Elements elements;
    private final Messager messager;
    private final FieldValuesParser fieldValuesParser;
    private final Map<TypeElement, Map<String, Object>> defaultValues = new HashMap<TypeElement, Map<String, Object>>();
    private final String configurationPropertiesAnnotation;
    private final String autowiredAnnotation;

    MetadataGenerationEnvironment(ProcessingEnvironment environment, String configurationPropertiesAnnotation, String autowiredAnnotation) {
        this.typeUtils = new TypeUtils(environment);
        this.elements = environment.getElementUtils();
        this.messager = environment.getMessager();
        this.fieldValuesParser = MetadataGenerationEnvironment.resolveFieldValuesParser(environment);
        this.configurationPropertiesAnnotation = configurationPropertiesAnnotation;
        this.autowiredAnnotation = autowiredAnnotation;
    }

    private static FieldValuesParser resolveFieldValuesParser(ProcessingEnvironment env) {
        try {
            return new JavaCompilerFieldValuesParser(env);
        }
        catch (Throwable ex) {
            return FieldValuesParser.NONE;
        }
    }

    TypeUtils getTypeUtils() {
        return this.typeUtils;
    }

    Messager getMessager() {
        return this.messager;
    }

    Object getFieldDefaultValue(TypeElement type, String name) {
        return this.defaultValues.computeIfAbsent(type, this::resolveFieldValues).get(name);
    }

    boolean isExcluded(TypeMirror type) {
        if (type == null) {
            return false;
        }
        String typeName = type.toString();
        if (typeName.endsWith("[]")) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        return TYPE_EXCLUDES.contains(typeName);
    }

    boolean hasAutowiredAnnotation(ExecutableElement element) {
        return this.hasAnnotation(element, this.autowiredAnnotation);
    }

    boolean hasAnnotation(Element element, String type) {
        return this.hasAnnotation(element, type, false);
    }

    boolean hasAnnotation(Element element, String type, boolean considerMetaAnnotations) {
        if (element != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!type.equals(annotationMirror.getAnnotationType().toString())) continue;
                return true;
            }
            if (considerMetaAnnotations) {
                HashSet<Element> seen = new HashSet<Element>();
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (!this.hasMetaAnnotation(annotationMirror.getAnnotationType().asElement(), type, seen)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasMetaAnnotation(Element annotationElement, String type, Set<Element> seen) {
        if (seen.add(annotationElement)) {
            for (AnnotationMirror annotationMirror : annotationElement.getAnnotationMirrors()) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (!type.equals(annotationType.toString()) && !this.hasMetaAnnotation(annotationType.asElement(), type, seen)) continue;
                return true;
            }
        }
        return false;
    }

    AnnotationMirror getAnnotation(Element element, String type) {
        if (element != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!type.equals(annotationMirror.getAnnotationType().toString())) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    List<Element> getElementsAnnotatedOrMetaAnnotatedWith(Element element, TypeElement annotationType) {
        LinkedList<Element> stack = new LinkedList<Element>();
        stack.push(element);
        this.collectElementsAnnotatedOrMetaAnnotatedWith(annotationType, stack);
        stack.removeFirst();
        return Collections.unmodifiableList(stack);
    }

    private boolean collectElementsAnnotatedOrMetaAnnotatedWith(TypeElement annotationType, LinkedList<Element> stack) {
        Element element = stack.peekLast();
        for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(element)) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (stack.contains(annotationElement)) continue;
            stack.addLast(annotationElement);
            if (annotationElement.equals(annotationType)) {
                return true;
            }
            if (this.collectElementsAnnotatedOrMetaAnnotatedWith(annotationType, stack)) continue;
            stack.removeLast();
        }
        return false;
    }

    Map<String, Object> getAnnotationElementValues(AnnotationMirror annotation) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        annotation.getElementValues().forEach((name, value) -> values.put(name.getSimpleName().toString(), this.getAnnotationValue((AnnotationValue)value)));
        return values;
    }

    String getAnnotationElementStringValue(AnnotationMirror annotation, String name) {
        return annotation.getElementValues().entrySet().stream().filter(element -> ((ExecutableElement)element.getKey()).getSimpleName().toString().equals(name)).map(element -> this.asString(this.getAnnotationValue((AnnotationValue)element.getValue()))).findFirst().orElse(null);
    }

    private Object getAnnotationValue(AnnotationValue annotationValue) {
        Object value = annotationValue.getValue();
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            ((List)value).forEach(v -> values.add(((AnnotationValue)v).getValue()));
            return values;
        }
        return value;
    }

    private String asString(Object value) {
        return value == null || value.toString().isEmpty() ? null : (String)value;
    }

    TypeElement getConfigurationPropertiesAnnotationElement() {
        return this.elements.getTypeElement(this.configurationPropertiesAnnotation);
    }

    AnnotationMirror getConfigurationPropertiesAnnotation(Element element) {
        return this.getAnnotation(element, this.configurationPropertiesAnnotation);
    }

    boolean hasNullableAnnotation(Element element) {
        return this.getAnnotation(element, NULLABLE_ANNOTATION) != null;
    }

    private Map<String, Object> resolveFieldValues(TypeElement element) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        this.resolveFieldValuesFor(values, element);
        return values;
    }

    private void resolveFieldValuesFor(Map<String, Object> values, TypeElement element) {
        try {
            this.fieldValuesParser.getFieldValues(element).forEach((name, value) -> {
                if (!values.containsKey(name)) {
                    values.put((String)name, value);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        Element superType = this.typeUtils.asElement(element.getSuperclass());
        if (superType instanceof TypeElement && superType.asType().getKind() != TypeKind.NONE) {
            this.resolveFieldValuesFor(values, (TypeElement)superType);
        }
    }
}

