/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.banner.integration;

import java.io.IOException;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.util.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BannerPlugin
implements Plugin {
    static final Logger log = LoggerFactory.getLogger(BannerPlugin.class);
    private String BANNER_DEF_FILE = "META-INF/solon_def/banner-def.txt";

    public BannerPlugin() throws IOException {
        boolean enable = Solon.cfg().getBool("solon.banner.enable", true);
        if (enable) {
            String mode = Solon.cfg().get("solon.banner.mode", "console");
            String path = Solon.cfg().get("solon.banner.path", "banner.txt");
            String bannerTxt = ResourceUtil.getResourceAsString((String)path);
            if (Utils.isEmpty((String)bannerTxt)) {
                bannerTxt = ResourceUtil.getResourceAsString((String)this.BANNER_DEF_FILE);
            }
            if (Utils.isEmpty((String)bannerTxt)) {
                return;
            }
            bannerTxt = bannerTxt.replace("${solon.version}", Solon.version());
            switch (mode) {
                case "log": {
                    log.info(bannerTxt);
                    break;
                }
                case "both": {
                    log.info(bannerTxt);
                }
                default: {
                    System.out.println(bannerTxt);
                }
            }
        }
    }

    public void start(AppContext context) throws Throwable {
    }
}

