/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.impl.CloudLoadStrategy;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.event.EventBus;

public class CloudLoadBalance
implements LoadBalance {
    private final String service;
    private final String group;
    private Discovery discovery;

    @Deprecated
    public static void setStrategy(CloudLoadStrategy strategy) {
        CloudManager.register(strategy);
    }

    public CloudLoadBalance(String group, String service) {
        this.service = service;
        this.group = group;
        if (CloudClient.discovery() != null) {
            this.setDiscovery(CloudClient.discovery().find(group, service));
            CloudClient.discovery().attention(group, service, this::setDiscovery);
        }
    }

    public CloudLoadBalance(String group, String service, Discovery discovery) {
        this.service = service;
        this.group = group;
        this.setDiscovery(discovery);
    }

    private void setDiscovery(Discovery discovery) {
        if (discovery != null) {
            this.discovery = discovery;
            EventBus.publish((Object)discovery);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getService() {
        return this.service;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public String getServer(int port) {
        if (this.discovery == null) {
            return null;
        }
        if (Utils.isNotEmpty((String)this.discovery.agent())) {
            return this.discovery.agent();
        }
        if (this.discovery.clusterSize() == 0) {
            return null;
        }
        return CloudClient.loadStrategy().getServer(this.discovery, port);
    }
}

