/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route;

import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.properties.TimeoutProperties;
import org.noear.solon.cloud.gateway.route.Route;
import org.noear.solon.cloud.gateway.route.RouteFactoryManager;
import org.noear.solon.cloud.gateway.route.predicate.PathPredicateFactory;
import org.noear.solon.core.util.RankEntity;

public class RouteSpec
extends Route {
    public RouteSpec(String id) {
        super(id);
    }

    public RouteSpec index(int index) {
        this.index = index;
        return this;
    }

    public RouteSpec target(URI uri) {
        this.target = uri;
        return this;
    }

    public RouteSpec target(String uri) {
        return this.target(URI.create(uri));
    }

    public RouteSpec timeout(TimeoutProperties timeout) {
        this.timeout = timeout;
        return this;
    }

    public RouteSpec filter(ExFilter filter) {
        return this.filter(filter, 0);
    }

    public RouteSpec filters(Collection<ExFilter> filters) {
        for (ExFilter filter : filters) {
            this.filter(filter, 0);
        }
        return this;
    }

    public RouteSpec filter(ExFilter filter, int index) {
        if (filter != null) {
            this.filters.add(new RankEntity((Object)filter, index));
            this.filters.sort(Comparator.comparingInt(e -> e.index));
        }
        return this;
    }

    public RouteSpec predicate(ExPredicate predicate) {
        if (predicate != null) {
            this.predicates.add(predicate);
            if (predicate instanceof PathPredicateFactory.PathPredicate) {
                this.depth = ((PathPredicateFactory.PathPredicate)predicate).depth();
            }
        }
        return this;
    }

    public RouteSpec path(String path) {
        ExPredicate predicate = RouteFactoryManager.getPredicate("Path", path);
        return this.predicate(predicate);
    }
}

