/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.predicate;

import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;

public class RemoteAddrPredicateFactory
implements RoutePredicateFactory {
    @Override
    public String prefix() {
        return "RemoteAddr";
    }

    @Override
    public ExPredicate create(String config) {
        return new RemoteAddrPredicate(config);
    }

    public static class RemoteAddrPredicate
    implements ExPredicate {
        private final IpSubnetFilterRule rule;

        public RemoteAddrPredicate(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("RemoteAddr config cannot be blank");
            }
            String[] parts = config.split("/");
            String ip = parts[0];
            try {
                InetAddress address = InetAddress.getByName(ip);
                int mask = parts.length > 1 ? Integer.parseInt(parts[1]) : (address instanceof Inet4Address ? 32 : 128);
                this.rule = new IpSubnetFilterRule(address, mask, IpFilterRuleType.ACCEPT);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("RemoteAddr config is wrong: " + config, e);
            }
        }

        @Override
        public boolean test(ExContext ctx) {
            String ip = ctx.realIp();
            if (Utils.isEmpty((String)ip)) {
                return false;
            }
            return this.rule.matches(new InetSocketAddress(ip, 1));
        }
    }
}

