/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.predicate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;
import org.noear.solon.core.handle.MethodType;

public class MethodPredicateFactory
implements RoutePredicateFactory {
    private static final Set<String> VALID_METHODS = new HashSet<String>(Arrays.asList(MethodType.GET.name(), MethodType.POST.name(), MethodType.PUT.name(), MethodType.DELETE.name(), MethodType.PATCH.name(), MethodType.OPTIONS.name(), MethodType.HEAD.name()));

    @Override
    public String prefix() {
        return "Method";
    }

    @Override
    public ExPredicate create(String config) {
        return new MethodPredicate(config);
    }

    public static class MethodPredicate
    implements ExPredicate {
        private final Set<String> methods;

        public MethodPredicate(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("MethodPredicate config cannot be blank");
            }
            this.methods = new HashSet<String>();
            for (String method : config.split(",")) {
                String trimmedMethod = method.trim().toUpperCase();
                if (!VALID_METHODS.contains(trimmedMethod)) {
                    throw new IllegalArgumentException("Invalid HTTP method: " + trimmedMethod);
                }
                this.methods.add(trimmedMethod);
            }
            if (this.methods.isEmpty()) {
                throw new IllegalArgumentException("No valid HTTP methods specified");
            }
        }

        @Override
        public boolean test(ExContext ctx) {
            return this.methods.contains(ctx.rawMethod());
        }
    }
}

