/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.filter;

import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExFilterChain;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.rx.Completable;

public class RemoveResponseHeaderFilterFactory
implements RouteFilterFactory {
    @Override
    public String prefix() {
        return "RemoveResponseHeader";
    }

    @Override
    public ExFilter create(String config) {
        return new RemoveResponseHeaderFilter(config);
    }

    public static class RemoveResponseHeaderFilter
    implements ExFilter {
        private final String[] names;

        public RemoveResponseHeaderFilter(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("RemoveResponseHeaderFilter config cannot be blank");
            }
            this.names = config.split(",");
            if (this.names.length == 0) {
                throw new IllegalArgumentException("RemoveResponseHeaderFilter config is wrong: " + config);
            }
        }

        @Override
        public Completable doFilter(ExContext ctx, ExFilterChain chain) {
            return Completable.create(emitter -> chain.doFilter(ctx).doOnError(err -> {
                ctx.newResponse().headerRemove(this.names);
                emitter.onError(err);
            }).doOnComplete(() -> {
                ctx.newResponse().headerRemove(this.names);
                emitter.onComplete();
            }).subscribe());
        }
    }
}

