/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.filter;

import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExFilterChain;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.rx.Completable;

public class RewritePathFilterFactory
implements RouteFilterFactory {
    @Override
    public String prefix() {
        return "RewritePath";
    }

    @Override
    public ExFilter create(String config) {
        return new RewritePathFilter(config);
    }

    public static class RewritePathFilter
    implements ExFilter {
        private final String replacement;
        private final Pattern pattern;

        public RewritePathFilter(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("RewritePathFilter config cannot be blank");
            }
            String[] parts = config.split(",");
            if (parts.length != 2) {
                throw new IllegalArgumentException("RewritePathFilter config is wrong: " + config);
            }
            String regex = parts[0].trim();
            String rawReplacement = parts[1].trim();
            if (!regex.startsWith("/") || !rawReplacement.startsWith("/")) {
                throw new IllegalArgumentException("RewritePathFilter config is wrong, path must be start with slash, config is : " + config);
            }
            this.pattern = Pattern.compile(regex);
            this.replacement = rawReplacement.replace("$\\", "$");
        }

        @Override
        public Completable doFilter(ExContext ctx, ExFilterChain chain) {
            String path = ctx.newRequest().getPath();
            String newPath = this.pattern.matcher(path).replaceAll(this.replacement);
            ctx.newRequest().path(newPath);
            return chain.doFilter(ctx);
        }
    }
}

