/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.ReadStream;
import io.vertx.solon.VertxHolder;
import java.util.Map;
import org.noear.solon.cloud.gateway.exchange.ExBody;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExContextImpl;
import org.noear.solon.cloud.gateway.exchange.impl.ExBodyOfBuffer;
import org.noear.solon.cloud.gateway.exchange.impl.ExBodyOfStream;
import org.noear.solon.cloud.gateway.route.RouteHandler;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.rx.Completable;
import org.noear.solon.rx.CompletableEmitter;

public class HttpRouteHandler
implements RouteHandler {
    private HttpClient httpClient;

    public HttpRouteHandler() {
        HttpClientOptions options = new HttpClientOptions().setMaxPoolSize(250).setConnectTimeout(3000).setIdleTimeout(60).setKeepAlive(true).setKeepAliveTimeout(60);
        this.httpClient = VertxHolder.getVertx().createHttpClient(options);
    }

    @Override
    public String[] schemas() {
        return new String[]{"http", "https"};
    }

    @Override
    public Completable handle(ExContext x) {
        try {
            ExContextImpl ctx = (ExContextImpl)x;
            ctx.rawRequest().pause();
            Future<HttpClientRequest> req1 = this.buildHttpRequest(ctx);
            return Completable.create(emitter -> req1.onComplete(ar -> {
                if (ar.succeeded()) {
                    this.handleDo(ctx, (HttpClientRequest)ar.result(), (CompletableEmitter)emitter);
                } else {
                    emitter.onError(ar.cause());
                }
            }));
        }
        catch (Throwable ex) {
            if (ex instanceof StatusException) {
                return Completable.error((Throwable)ex);
            }
            return Completable.error((Throwable)new StatusException(ex, 400));
        }
    }

    public void handleDo(ExContext ctx, HttpClientRequest req1, CompletableEmitter emitter) {
        try {
            ExBody exBody;
            for (KeyValues kv : ctx.newRequest().getHeaders()) {
                if ("Host".equals(kv.getKey())) {
                    req1.putHeader("X-Forwarded-Host", (Iterable)kv.getValues());
                    continue;
                }
                req1.putHeader(kv.getKey(), (Iterable)kv.getValues());
            }
            if (ctx.rawHeader("X-Real-IP") == null) {
                req1.putHeader("X-Real-IP", ctx.realIp());
            }
            if ((exBody = ctx.newRequest().getBody()) instanceof ExBodyOfBuffer) {
                req1.send(((ExBodyOfBuffer)exBody).getBuffer(), ar1 -> this.callbackHandle(ctx, (AsyncResult<HttpClientResponse>)ar1, emitter));
            } else {
                req1.send(((ExBodyOfStream)exBody).getStream(), ar1 -> this.callbackHandle(ctx, (AsyncResult<HttpClientResponse>)ar1, emitter));
            }
        }
        catch (Throwable ex) {
            if (ex instanceof StatusException) {
                emitter.onError(ex);
            }
            emitter.onError((Throwable)new StatusException(ex, 400));
        }
    }

    private Future<HttpClientRequest> buildHttpRequest(ExContext ctx) {
        RequestOptions requestOptions = new RequestOptions();
        if (ctx.timeout() != null) {
            requestOptions.setConnectTimeout((long)(ctx.timeout().getConnectTimeout() * 1000));
            requestOptions.setTimeout((long)(ctx.timeout().getResponseTimeout() * 1000));
        }
        requestOptions.setAbsoluteURI(ctx.targetNew() + ctx.newRequest().getPathAndQueryString());
        requestOptions.setMethod(HttpMethod.valueOf((String)ctx.newRequest().getMethod()));
        return this.httpClient.request(requestOptions);
    }

    private void callbackHandle(ExContext ctx, AsyncResult<HttpClientResponse> ar, CompletableEmitter subscriber) {
        try {
            if (ar.succeeded()) {
                HttpClientResponse resp1 = (HttpClientResponse)ar.result();
                ctx.newResponse().status(resp1.statusCode());
                for (Map.Entry kv : resp1.headers()) {
                    ctx.newResponse().headerAdd((String)kv.getKey(), (String)kv.getValue());
                }
                ctx.newResponse().body((ReadStream<Buffer>)resp1);
                subscriber.onComplete();
            } else {
                subscriber.onError(ar.cause());
            }
        }
        catch (Throwable ex) {
            subscriber.onError(ex);
        }
    }
}

