/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.noear.solon.cloud.gateway.CloudRouteRegister;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.route.Route;
import org.noear.solon.cloud.gateway.route.RouteSpec;
import org.noear.solon.core.util.RankEntity;

public class CloudGatewayConfiguration
implements CloudRouteRegister {
    protected final Map<String, RouteSpec> routes = new ConcurrentHashMap<String, RouteSpec>();
    protected final List<ExFilter> routeDefaultFilters = new ArrayList<ExFilter>();
    protected List<RankEntity<ExFilter>> filters = new ArrayList<RankEntity<ExFilter>>();

    public void filter(ExFilter filter) {
        this.filter(filter, 0);
    }

    public void filter(ExFilter filter, int index) {
        if (filter != null) {
            this.filters.add((RankEntity<ExFilter>)new RankEntity(filter::doFilter, index));
            this.filters.sort(Comparator.comparingInt(e -> e.index));
        }
    }

    public void routeDefaultFilter(ExFilter filter) {
        if (filter != null) {
            this.routeDefaultFilters.add(filter);
        }
    }

    @Override
    public CloudRouteRegister route(String id, Consumer<RouteSpec> builder) {
        RouteSpec route = this.routes.computeIfAbsent(id, k -> new RouteSpec(id).filters(this.routeDefaultFilters));
        builder.accept(route);
        return this;
    }

    @Override
    public CloudRouteRegister route(RouteSpec route) {
        if (route != null) {
            this.routes.put(route.getId(), route.filters(this.routeDefaultFilters));
        }
        return this;
    }

    @Override
    public CloudRouteRegister routeRemove(String id) {
        this.routes.remove(id);
        return this;
    }

    public Route routeFind(ExContext ctx) {
        ArrayList<RouteSpec> routeList = new ArrayList<RouteSpec>(this.routes.values());
        routeList.sort(Comparator.comparingInt(r -> r.getIndex()));
        for (Route route : routeList) {
            if (!route.matched(ctx)) continue;
            return route;
        }
        return null;
    }
}

