/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import org.noear.solon.cloud.gateway.exchange.ExBody;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.impl.ExBodyOfBuffer;
import org.noear.solon.cloud.gateway.exchange.impl.ExBodyOfStream;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.util.KeyValues;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudGatewayCompletion
implements Subscriber<Void> {
    static final Logger log = LoggerFactory.getLogger(CloudGatewayCompletion.class);
    private final ExContext ctx;
    private final HttpServerRequest rawRequest;

    public CloudGatewayCompletion(ExContext ctx, HttpServerRequest rawRequest) {
        this.ctx = ctx;
        this.rawRequest = rawRequest;
    }

    public void onSubscribe(Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(Void unused) {
    }

    public void onError(Throwable throwable) {
        try {
            if (throwable instanceof StatusException) {
                StatusException status = (StatusException)throwable;
                this.ctx.newResponse().status(status.getCode());
                if (status.getCode() == 404) {
                    return;
                }
            } else {
                this.ctx.newResponse().status(500);
            }
            log.error(throwable.getMessage(), throwable);
        }
        finally {
            this.postComplete();
        }
    }

    public void onComplete() {
        this.postComplete();
    }

    public void postComplete() {
        try {
            HttpServerResponse rawResponse = this.rawRequest.response();
            if (!rawResponse.headWritten()) {
                rawResponse.setStatusCode(this.ctx.newResponse().getStatus());
                for (KeyValues kv : this.ctx.newResponse().getHeaders()) {
                    rawResponse.putHeader(kv.getKey(), (Iterable)kv.getValues());
                }
            }
            if (!rawResponse.ended()) {
                if (this.ctx.newResponse().getBody() != null) {
                    ExBody exBody;
                    if (this.ctx.newResponse().getBody() instanceof ExBodyOfStream) {
                        exBody = (ExBodyOfStream)this.ctx.newResponse().getBody();
                        rawResponse.send(((ExBodyOfStream)exBody).getStream());
                    } else {
                        exBody = (ExBodyOfBuffer)this.ctx.newResponse().getBody();
                        rawResponse.send(((ExBodyOfBuffer)exBody).getBuffer());
                    }
                } else {
                    rawResponse.end();
                }
            }
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
        }
    }
}

