/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.integration;

import org.noear.solon.Utils;
import org.noear.solon.boot.vertx.http.VxHandlerSupplier;
import org.noear.solon.boot.vertx.http.VxHandlerSupplierDefault;
import org.noear.solon.cloud.gateway.CloudGatewayFilter;
import org.noear.solon.cloud.gateway.CloudGatewayHandler;
import org.noear.solon.cloud.gateway.CloudRouteRegister;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.integration.GatewayHandlerSupplier;
import org.noear.solon.cloud.gateway.integration.GatewayLocator;
import org.noear.solon.cloud.gateway.properties.GatewayProperties;
import org.noear.solon.cloud.gateway.route.RouteFactoryManager;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.cloud.gateway.route.RouteHandler;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.bean.LifecycleBean;

public class XPluginImpl
implements Plugin {
    private static final String SOLON_CLOUD_GATEWAY = "solon.cloud.gateway";

    public void start(AppContext context) throws Throwable {
        Props gatewayProps = context.cfg().getProp(SOLON_CLOUD_GATEWAY);
        GatewayProperties gatewayProperties = gatewayProps.size() > 0 ? (GatewayProperties)gatewayProps.toBean(GatewayProperties.class) : new GatewayProperties();
        VxHandlerSupplierDefault webHandlerSupplier = new VxHandlerSupplierDefault();
        CloudGatewayHandler cloudGateway = new CloudGatewayHandler(webHandlerSupplier.get());
        GatewayHandlerSupplier gatewayHandlerSupplier = new GatewayHandlerSupplier(cloudGateway);
        context.wrapAndPut(VxHandlerSupplier.class, (Object)gatewayHandlerSupplier);
        if (Utils.isNotEmpty(gatewayProperties.getDefaultFilters())) {
            for (String defaultFilter : gatewayProperties.getDefaultFilters()) {
                cloudGateway.getConfiguration().routeDefaultFilter(RouteFactoryManager.buildFilter(defaultFilter));
            }
        }
        context.wrapAndPut(CloudRouteRegister.class, (Object)cloudGateway.getConfiguration());
        context.subWrapsOfType(CloudGatewayFilter.class, bw -> cloudGateway.getConfiguration().filter((ExFilter)bw.raw(), bw.index()));
        context.subBeansOfType(RouteHandler.class, b -> RouteFactoryManager.addHandler(b));
        context.subBeansOfType(RouteFilterFactory.class, b -> RouteFactoryManager.addFactory(b));
        context.subBeansOfType(RoutePredicateFactory.class, b -> RouteFactoryManager.addFactory(b));
        GatewayLocator gatewayLocator = new GatewayLocator(gatewayProperties, cloudGateway.getConfiguration());
        context.lifecycle(-1, (LifecycleBean)gatewayLocator);
    }
}

