/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.exchange;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExBody;
import org.noear.solon.cloud.gateway.exchange.impl.ExBodyOfBuffer;
import org.noear.solon.cloud.gateway.exchange.impl.ExBodyOfStream;
import org.noear.solon.core.util.MultiMap;

public class ExNewRequest {
    private String method;
    private String queryString;
    private String path;
    private MultiMap<String> headers = new MultiMap();
    private ExBody body;

    public ExNewRequest method(String method) {
        this.method = method;
        return this;
    }

    public ExNewRequest path(String path) {
        this.path = path;
        return this;
    }

    public ExNewRequest queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public ExNewRequest header(String key, String ... values) {
        this.headers.holder(key).setValues((Object[])values);
        return this;
    }

    public ExNewRequest header(String key, List<String> values) {
        this.headers.holder(key).setValues((Object[])values.toArray(new String[values.size()]));
        return this;
    }

    public ExNewRequest headerAdd(String key, String value) {
        this.headers.holder(key).addValue((Object)value);
        return this;
    }

    public ExNewRequest headerRemove(String ... keys) {
        for (String key : keys) {
            this.headers.remove(key);
        }
        return this;
    }

    public ExNewRequest body(Buffer body) {
        this.body = new ExBodyOfBuffer(body);
        return this;
    }

    public ExNewRequest body(ReadStream<Buffer> body) {
        this.body = new ExBodyOfStream(body);
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPath() {
        return this.path;
    }

    public String getPathAndQueryString() {
        if (Utils.isEmpty((String)this.getQueryString())) {
            return this.getPath();
        }
        return this.getPath() + "?" + this.getQueryString();
    }

    public MultiMap<String> getHeaders() {
        return this.headers;
    }

    public ExBody getBody() {
        return this.body;
    }
}

