/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;

public class StringMutexLock {
    private final ConcurrentMap<String, CountDownLatch> lockKeyHolder = new ConcurrentHashMap<String, CountDownLatch>();

    public AutoCloseable lockEntry(String lockKey) {
        this.lock(lockKey);
        return () -> this.unlock(lockKey);
    }

    public void lock(String lockKey) {
        while (true) {
            CountDownLatch existing;
            if ((existing = (CountDownLatch)this.lockKeyHolder.get(lockKey)) != null) {
                try {
                    existing.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Locking interrupted", e);
                }
            }
            CountDownLatch newLatch = new CountDownLatch(1);
            existing = this.lockKeyHolder.putIfAbsent(lockKey, newLatch);
            if (existing == null) {
                return;
            }
            try {
                existing.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Locking interrupted", e);
            }
        }
    }

    public void unlock(String lockKey) {
        CountDownLatch latch = (CountDownLatch)this.lockKeyHolder.remove(lockKey);
        if (latch != null) {
            latch.countDown();
        }
    }
}

