/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.redisson;

import java.net.URL;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

public class RedissonClientOriginalSupplier
implements Supplier<RedissonClient> {
    private Properties properties;
    private Consumer<Config> configHandler;

    public RedissonClientOriginalSupplier withConfig(Consumer<Config> configHandler) {
        this.configHandler = configHandler;
        return this;
    }

    public RedissonClientOriginalSupplier(Properties properties) {
        this.properties = properties;
    }

    @Override
    public RedissonClient get() {
        try {
            String fileUri = this.properties.getProperty("file");
            if (Utils.isNotEmpty((String)fileUri)) {
                URL url = ResourceUtil.findResource((String)fileUri);
                Config config = Config.fromYAML((URL)url);
                if (this.configHandler != null) {
                    this.configHandler.accept(config);
                }
                return Redisson.create((Config)config);
            }
            String configTxt = this.properties.getProperty("config");
            if (Utils.isNotEmpty((String)configTxt)) {
                Config config = Config.fromYAML((String)configTxt);
                if (this.configHandler != null) {
                    this.configHandler.accept(config);
                }
                return Redisson.create((Config)config);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("The redisson configuration failed", e);
        }
        throw new IllegalStateException("Invalid redisson configuration");
    }
}

