/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.vertx;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.http.HttpServerConfigure;
import org.noear.solon.boot.vertx.VxHttpServer;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.handle.Handler;

public class VxHttpServerComb
implements HttpServerConfigure,
ServerLifecycle {
    private final AppContext context;
    private Executor workExecutor;
    private boolean enableWebSocket;
    private Handler handler;
    private boolean enableSsl = true;
    private boolean enableHttp2 = false;
    private SSLContext sslContext;
    private Set<Integer> addHttpPorts = new LinkedHashSet<Integer>();
    private List<VxHttpServer> servers = new ArrayList<VxHttpServer>();

    public VxHttpServerComb(AppContext context) {
        this.context = context;
    }

    public void enableSsl(boolean enable, SSLContext sslContext) {
        this.enableSsl = enable;
        this.sslContext = sslContext;
    }

    public void enableHttp2(boolean enable) {
        this.enableHttp2 = enable;
    }

    public void addHttpPort(int port) {
        this.addHttpPorts.add(port);
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.workExecutor = executor;
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public boolean isSecure() {
        if (this.servers.size() > 0) {
            return this.servers.get(0).isSecure();
        }
        return false;
    }

    public void start(String host, int port) throws Throwable {
        VxHttpServer s1 = new VxHttpServer(this.context, true);
        s1.setWorkExecutor(this.workExecutor);
        s1.enableWebSocket(this.enableWebSocket);
        s1.setHandler(this.handler);
        s1.enableSsl(this.enableSsl, this.sslContext);
        s1.enableHttp2(this.enableHttp2);
        s1.start(host, port);
        this.servers.add(s1);
        for (Integer portAdd : this.addHttpPorts) {
            VxHttpServer s2 = new VxHttpServer(this.context, false);
            s2.setWorkExecutor(this.workExecutor);
            s2.enableWebSocket(this.enableWebSocket);
            s2.setHandler(this.handler);
            s2.enableSsl(false, null);
            s2.start(host, portAdd);
            this.servers.add(s2);
        }
    }

    public void stop() throws Throwable {
        for (ServerLifecycle serverLifecycle : this.servers) {
            serverLifecycle.stop();
        }
    }
}

