/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.vertx.websocket;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.noear.solon.Utils;
import org.noear.solon.boot.vertx.websocket.CallbackFuture;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;

public class VxWebSocketImpl
extends WebSocketTimeoutBase {
    private ServerWebSocket real;

    public VxWebSocketImpl(ServerWebSocket real) {
        this.real = real;
        this.init(this.buildUri(real));
    }

    public URI buildUri(ServerWebSocket req) {
        if (Utils.isEmpty((String)req.query())) {
            return URI.create(req.uri());
        }
        if (req.uri().contains("?")) {
            return URI.create(req.uri());
        }
        return URI.create(req.uri() + "?" + req.query());
    }

    public boolean isValid() {
        return !this.isClosed();
    }

    public boolean isSecure() {
        return this.real.isSsl();
    }

    public InetSocketAddress remoteAddress() throws IOException {
        return (InetSocketAddress)this.real.remoteAddress();
    }

    public InetSocketAddress localAddress() throws IOException {
        return (InetSocketAddress)this.real.localAddress();
    }

    public Future<Void> send(String text) {
        CallbackFuture future = new CallbackFuture();
        this.real.writeFinalTextFrame(text, (Handler)future);
        this.onSend();
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        CallbackFuture future = new CallbackFuture();
        this.real.writeBinaryMessage(Buffer.buffer((byte[])binary.array()), (Handler)future);
        this.onSend();
        return future;
    }

    public void close() {
        super.close();
        RunUtil.runAndTry(() -> ((ServerWebSocket)this.real).close());
    }
}

