/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.vertx;

import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.CookieImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.io.LimitedInputStream;
import org.noear.solon.boot.vertx.ResponseOutputStream;
import org.noear.solon.boot.web.BodyUtils;
import org.noear.solon.boot.web.RedirectUtils;
import org.noear.solon.boot.web.WebContextBase;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.core.util.RunUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxWebContext
extends WebContextBase {
    static final Logger log = LoggerFactory.getLogger(VxWebContext.class);
    private HttpServerRequest _request;
    private HttpServerResponse _response;
    private Buffer _requestBody;
    private boolean _isAsync;
    private long _asyncTimeout = 30000L;
    private List<ContextAsyncListener> _asyncListeners = new ArrayList<ContextAsyncListener>();
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private int contentLength = -2;
    private InputStream bodyAsStream;
    private MultiMap<String> _paramMap;
    private MultiMap<String> _cookieMap;
    private MultiMap<String> _headerMap;
    private ResponseOutputStream responseOutputStream;
    private ByteArrayOutputStream _outputStreamTmp;
    private int _status = 200;
    private boolean _headers_sent = false;
    private boolean _allows_write = true;

    protected HttpServerRequest innerGetRequest() {
        return this._request;
    }

    protected HttpServerResponse innerGetResponse() {
        return this._response;
    }

    protected boolean innerIsAsync() {
        return this._isAsync;
    }

    protected List<ContextAsyncListener> innerAsyncListeners() {
        return this._asyncListeners;
    }

    public VxWebContext(HttpServerRequest request, Buffer requestBody) {
        this._request = request;
        this._requestBody = requestBody;
        this._response = request.response();
    }

    private void loadMultipartFormData() {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            BodyUtils.decodeMultipart((Context)this, (MultiMap)this._fileMap);
        }
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        return this._request.remoteAddress().host();
    }

    public int remotePort() {
        return this._request.remoteAddress().port();
    }

    public String method() {
        return this._request.method().name();
    }

    public String protocol() {
        return "http";
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return false;
    }

    public String url() {
        return this._request.absoluteURI();
    }

    public long contentLength() {
        if (this.contentLength > -2) {
            return this.contentLength;
        }
        String tmp = this._request.getHeader("Content-Length");
        this.contentLength = Utils.isEmpty((String)tmp) ? -1 : Integer.parseInt(tmp);
        return this.contentLength;
    }

    public String queryString() {
        return this._request.query();
    }

    public InputStream bodyAsStream() throws IOException {
        if (this.bodyAsStream != null) {
            return this.bodyAsStream;
        }
        this.bodyAsStream = this._requestBody == null ? new ByteArrayInputStream(new byte[0]) : new LimitedInputStream((InputStream)new ByteBufInputStream(this._requestBody.getByteBuf()), ServerProps.request_maxBodySize);
        return this.bodyAsStream;
    }

    public String body(String charset) throws IOException {
        try {
            return super.body(charset);
        }
        catch (Exception e) {
            throw BodyUtils.status4xx((Context)this, (Exception)e);
        }
    }

    public MultiMap<String> paramMap() {
        this.paramsMapInit();
        return this._paramMap;
    }

    private void paramsMapInit() {
        if (this._paramMap == null) {
            this._paramMap = new MultiMap();
            try {
                BodyUtils.decodeFormUrlencoded((Context)this, (boolean)false);
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (Map.Entry kv : this._request.params()) {
                    this._paramMap.add((String)kv.getKey(), kv.getValue());
                }
                for (Map.Entry kv : this._request.formAttributes()) {
                    this._paramMap.add((String)kv.getKey(), kv.getValue());
                }
            }
            catch (Exception e) {
                throw BodyUtils.status4xx((Context)this, (Exception)e);
            }
        }
    }

    public MultiMap<UploadedFile> fileMap() {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
        }
        return this._fileMap;
    }

    public MultiMap<String> cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new MultiMap();
            for (Cookie c1 : this._request.cookies()) {
                this._cookieMap.add(c1.getName(), (Object)c1.getValue());
            }
        }
        return this._cookieMap;
    }

    public MultiMap<String> headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new MultiMap();
            for (Map.Entry kv : this._request.headers()) {
                this._headerMap.add((String)kv.getKey(), kv.getValue());
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    private ResponseOutputStream responseOutputStream() {
        if (this.responseOutputStream == null) {
            this.responseOutputStream = new ResponseOutputStream(this._response, 512);
        }
        return this.responseOutputStream;
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders(false);
        if (this._allows_write) {
            return this.responseOutputStream();
        }
        if (this._outputStreamTmp == null) {
            this._outputStreamTmp = new ByteArrayOutputStream();
        } else {
            this._outputStreamTmp.reset();
        }
        return this._outputStreamTmp;
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            IoUtil.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String name, String val) {
        this._response.headers().set(name, val);
    }

    public void headerAdd(String name, String val) {
        this._response.headers().add(name, val);
    }

    public String headerOfResponse(String name) {
        return this._response.headers().get(name);
    }

    public Collection<String> headerValuesOfResponse(String name) {
        return this._response.headers().getAll(name);
    }

    public Collection<String> headerNamesOfResponse() {
        return this._response.headers().names();
    }

    public void cookieSet(String name, String val, String domain, String path, int maxAge) {
        CookieImpl cookie = new CookieImpl(name, val);
        if (Utils.isNotEmpty((String)path)) {
            cookie.setPath(path);
        }
        if (maxAge >= 0) {
            cookie.setMaxAge((long)maxAge);
        }
        if (Utils.isNotEmpty((String)domain)) {
            cookie.setDomain(domain);
        }
        this._response.addCookie((Cookie)cookie);
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._status;
    }

    protected void statusDoSet(int status) {
        this._status = status;
    }

    public void contentLength(long size) {
        if (!this._headers_sent) {
            this._response.putHeader("Content-Length", String.valueOf(size));
        }
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this.outputStream().flush();
        }
    }

    public void close() throws IOException {
        this._response.close();
    }

    public boolean asyncSupported() {
        return true;
    }

    public void asyncStart(long timeout, ContextAsyncListener listener, Runnable runnable) {
        if (!this._isAsync) {
            this._isAsync = true;
            if (listener != null) {
                this._asyncListeners.add(listener);
            }
            if (timeout != 0L) {
                this._asyncTimeout = timeout;
            }
            if (this._asyncTimeout > 0L) {
                RunUtil.delay(() -> {
                    for (ContextAsyncListener listener1 : this._asyncListeners) {
                        try {
                            listener1.onTimeout((Context)this);
                        }
                        catch (IOException e) {
                            log.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                }, (long)this._asyncTimeout);
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void asyncComplete() {
        if (this._isAsync) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
            }
            finally {
                if (!this._response.ended()) {
                    this._response.end();
                }
            }
        }
    }

    protected void innerCommit() throws IOException {
        if (this.getHandled() || this.status() >= 200) {
            this.sendHeaders(true);
            this.flush();
            this._response.send();
        } else {
            this.status(404);
            this.sendHeaders(true);
            this.flush();
            this._response.send();
        }
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            this._response.setStatusCode(this.status());
            if (isCommit || !this._allows_write) {
                this._response.setChunked(true);
            } else if (!this._response.headers().contains("Content-Length")) {
                this._response.setChunked(true);
            }
        }
    }
}

