/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.boot.prop.impl.WebSocketServerProps;
import org.noear.solon.boot.smarthttp.SmHttpServerComb;
import org.noear.solon.boot.smarthttp.http.MultipartUtil;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private SmHttpServerComb _server;
    private static final String SMARTHTTP_LOG_LEVEL = "smarthttp.log.level";

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "smart http 2.5/" + Solon.version();
    }

    public void start(AppContext context) {
        if (!context.app().enableHttp()) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.boot.jetty.XPluginImp") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.boot.undertow.XPluginImp") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.boot.vertx.XPluginImp") != null) {
            return;
        }
        context.lifecycle(99, () -> this.start0(context));
    }

    private void start0(AppContext context) throws Throwable {
        if (Utils.isEmpty((String)System.getProperty(SMARTHTTP_LOG_LEVEL))) {
            System.setProperty(SMARTHTTP_LOG_LEVEL, "WARNING");
        }
        ServerProps.init();
        MultipartUtil.init();
        HttpServerProps props = HttpServerProps.getInstance();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        this._server = new SmHttpServerComb();
        this._server.enableWebSocket(context.app().enableWebSocket());
        this._server.setCoreThreads(props.getCoreThreads());
        if (props.isIoBound()) {
            this._server.setExecutor(props.newWorkExecutor("smarthttp-"));
        }
        this._server.setHandler(arg_0 -> ((SolonApp)context.app()).tryHandle(arg_0));
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        context.app().signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: smarthttp: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (context.app().enableWebSocket()) {
            WebSocketServerProps wsProps = WebSocketServerProps.getInstance();
            if (Utils.isNotEmpty((String)wsProps.getName())) {
                SignalSim wsSignal = new SignalSim(wsProps.getName(), _wrapHost, _wrapPort, "ws", SignalType.WEBSOCKET);
                context.app().signalAdd((Signal)wsSignal);
            }
            String wsServerUrl = props.buildWsServerUrl(this._server.isSecure());
            LogUtil.global().info(connectorInfo + "[WebSocket]}{" + wsServerUrl + "}");
        }
        String httpServerUrl = props.buildHttpServerUrl(this._server.isSecure());
        LogUtil.global().info(connectorInfo + "}{" + httpServerUrl + "}");
        LogUtil.global().info("Server:main: smarthttp: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: smarthttp: Has Stopped (" + XPluginImp.solon_boot_ver() + ")");
        }
    }
}

