/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.jetty.HandlerHub;
import org.noear.solon.boot.jetty.JettyServerBase;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;

public class JettyServer
extends JettyServerBase
implements ServerLifecycle {
    protected Server real = null;
    protected boolean enableWebSocket;

    public JettyServer(HttpServerProps props) {
        super(props);
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public void start(String host, int port) throws Throwable {
        this.setup(host, port);
        this.real.start();
    }

    public void stop() throws Throwable {
        if (this.real != null) {
            this.real.stop();
            this.real = null;
        }
    }

    protected void setup(String host, int port) throws IOException {
        Class wsClz = ClassUtil.loadClass((String)"org.eclipse.jetty.websocket.server.WebSocketHandler");
        QueuedThreadPool threadPool = new QueuedThreadPool(this.props.getMaxThreads(this.props.isIoBound()), this.props.getCoreThreads());
        this.real = new Server((ThreadPool)threadPool);
        this.real.addConnector((Connector)this.getConnector(this.real, host, port, true));
        for (Integer portAdd : this.addHttpPorts) {
            this.real.addConnector((Connector)this.getConnector(this.real, host, portAdd, false));
        }
        if (this.enableSessionState) {
            this.real.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this.real));
        }
        if (this.enableWebSocket && wsClz != null) {
            this.real.setHandler((Handler)new HandlerHub(this.buildHandler()));
        } else {
            this.real.setHandler(this.buildHandler());
        }
        EventBus.publish((Object)this.real);
    }

    protected Handler buildHandler() throws IOException {
        return this.getServletHandler();
    }
}

