/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jdkhttp.JdkHttpServerComb;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    JdkHttpServerComb _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jdk http/" + Solon.version();
    }

    public void start(AppContext context) {
        if (!context.app().enableHttp()) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.boot.jetty.XPluginImp") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.boot.undertow.XPluginImp") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.boot.smarthttp.XPluginImp") != null) {
            return;
        }
        context.lifecycle(99, () -> this.start0(context));
    }

    private void start0(AppContext context) throws Throwable {
        ServerProps.init();
        HttpServerProps props = HttpServerProps.getInstance();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        this._server = new JdkHttpServerComb();
        this._server.setExecutor(props.newWorkExecutor("jdkhttp-"));
        this._server.setHandler(arg_0 -> ((SolonApp)context.app()).tryHandle(arg_0));
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        context.app().signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String httpServerUrl = props.buildHttpServerUrl(this._server.isSecure());
        LogUtil.global().info("Connector:main: jdkhttp: Started ServerConnector@{HTTP/1.1,[http/1.1]}{" + httpServerUrl + "}");
        LogUtil.global().info("Server:main: jdkhttp: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stop();
        this._server = null;
        LogUtil.global().info("Server:main: jdkhttp: Has Stopped (" + XPluginImp.solon_boot_ver() + ")");
    }
}

