/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.io.LimitedInputStream;
import org.noear.solon.boot.jdkhttp.ParameterUtil;
import org.noear.solon.boot.web.DecodeUtils;
import org.noear.solon.boot.web.RedirectUtils;
import org.noear.solon.boot.web.WebContextBase;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.Cookie;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkHttpContext
extends WebContextBase {
    static final Logger log = LoggerFactory.getLogger(JdkHttpContext.class);
    private HttpExchange _exchange;
    private boolean _isAsync;
    private long _asyncTimeout = 30000L;
    private CompletableFuture<Object> _asyncFuture;
    private List<ContextAsyncListener> _asyncListeners = new ArrayList<ContextAsyncListener>();
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private String _url;
    private long contentLength = -2L;
    private InputStream bodyAsStream;
    private MultiMap<String> _paramMap;
    private MultiMap<String> _cookieMap;
    private MultiMap<String> _headerMap;
    private ByteArrayOutputStream _outputStreamTmp;
    private int _status = 200;
    private boolean _allows_write = true;
    private boolean _headers_sent = false;

    protected boolean innerIsAsync() {
        return this._isAsync;
    }

    public JdkHttpContext(HttpExchange exchange) {
        this._exchange = exchange;
    }

    private void loadMultipartFormData() {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            DecodeUtils.decodeMultipart((Context)this, (MultiMap)this._fileMap);
        }
    }

    public Object request() {
        return this._exchange;
    }

    public String remoteIp() {
        return this._exchange.getRemoteAddress().getAddress().getHostAddress();
    }

    public int remotePort() {
        return this._exchange.getRemoteAddress().getPort();
    }

    public String method() {
        return this._exchange.getRequestMethod();
    }

    public String protocol() {
        return this._exchange.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return "https".equals(this.uri().getScheme());
    }

    public String url() {
        if (this._url == null) {
            this._url = this._exchange.getRequestURI().toString();
            if (this._url != null) {
                int idx;
                if (this._url.startsWith("/")) {
                    String host = this.header("Host");
                    if (host == null) {
                        host = this.header(":authority");
                        String scheme = this.header(":scheme");
                        if (host == null) {
                            host = "localhost";
                        }
                        this._url = scheme != null ? "https://" + host + this._url : scheme + "://" + host + this._url;
                    } else {
                        this._url = "http://" + host + this._url;
                    }
                }
                if ((idx = this._url.indexOf("?")) > 0) {
                    this._url = this._url.substring(0, idx);
                }
            }
        }
        return this._url;
    }

    public long contentLength() {
        if (this.contentLength < -1L) {
            this.contentLength = DecodeUtils.decodeContentLengthLong((Context)this);
        }
        return this.contentLength;
    }

    public String queryString() {
        return this._exchange.getRequestURI().getQuery();
    }

    public InputStream bodyAsStream() throws IOException {
        if (this.bodyAsStream == null) {
            this.bodyAsStream = new LimitedInputStream(this._exchange.getRequestBody(), ServerProps.request_maxBodySize);
        }
        return this.bodyAsStream;
    }

    public String body(String charset) throws IOException {
        try {
            return super.body(charset);
        }
        catch (Exception e) {
            throw DecodeUtils.status4xx((Context)this, (Exception)e);
        }
    }

    public MultiMap<String> paramMap() {
        this.paramsMapInit();
        return this._paramMap;
    }

    private void paramsMapInit() {
        if (this._paramMap == null) {
            this._paramMap = new MultiMap();
            try {
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                Map<String, Object> _parameters = ParameterUtil.doFilter(this._exchange);
                for (Map.Entry<String, Object> kv : _parameters.entrySet()) {
                    String k = kv.getKey();
                    Object v = kv.getValue();
                    if (v instanceof List) {
                        this._paramMap.holder(k).setValues((List)v);
                        continue;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    list.add((String)v);
                    this._paramMap.holder(k).setValues(list);
                }
            }
            catch (Exception e) {
                throw DecodeUtils.status4xx((Context)this, (Exception)e);
            }
        }
    }

    public MultiMap<UploadedFile> fileMap() {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
        }
        return this._fileMap;
    }

    public MultiMap<String> cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new MultiMap();
            DecodeUtils.decodeCookies((Context)this, (String)this.header("Cookie"));
        }
        return this._cookieMap;
    }

    public MultiMap<String> headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new MultiMap();
            Headers headers = this._exchange.getRequestHeaders();
            if (headers != null) {
                for (Map.Entry<String, List<String>> kv : headers.entrySet()) {
                    this._headerMap.holder(kv.getKey()).setValues(kv.getValue());
                }
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._exchange;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders(false);
        if (this._allows_write) {
            return this._exchange.getResponseBody();
        }
        if (this._outputStreamTmp == null) {
            this._outputStreamTmp = new ByteArrayOutputStream();
        } else {
            this._outputStreamTmp.reset();
        }
        return this._outputStreamTmp;
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            IoUtil.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._exchange.getResponseHeaders().set(key, val);
    }

    public void headerAdd(String key, String val) {
        this._exchange.getResponseHeaders().add(key, val);
    }

    public String headerOfResponse(String name) {
        return this._exchange.getResponseHeaders().getFirst(name);
    }

    public Collection<String> headerValuesOfResponse(String name) {
        return this._exchange.getResponseHeaders().get(name);
    }

    public Collection<String> headerNamesOfResponse() {
        return this._exchange.getResponseHeaders().keySet();
    }

    public void cookieSet(Cookie cookie) {
        StringBuilder buf = new StringBuilder();
        buf.append(cookie.name).append("=").append(cookie.value).append(";");
        if (cookie.maxAge >= 0) {
            buf.append("max-age=").append(cookie.maxAge).append(";");
        }
        if (Utils.isNotEmpty((String)cookie.domain)) {
            buf.append("domain=").append(cookie.domain.toLowerCase()).append(";");
        }
        if (Utils.isNotEmpty((String)cookie.path)) {
            buf.append("path=").append(cookie.path).append(";");
        }
        if (cookie.secure) {
            buf.append("secure").append(";");
        }
        if (cookie.httpOnly) {
            buf.append("httponly").append(";");
        }
        this.headerAdd("Set-Cookie", buf.toString());
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._status;
    }

    protected void statusDoSet(int status) {
        this._status = status;
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this.outputStream().flush();
        }
    }

    public void close() throws IOException {
        this._exchange.close();
    }

    public boolean asyncSupported() {
        return true;
    }

    public void asyncStart(long timeout, ContextAsyncListener listener, Runnable runnable) {
        if (!this._isAsync) {
            this._isAsync = true;
            this._asyncFuture = new CompletableFuture();
            if (listener != null) {
                this._asyncListeners.add(listener);
            }
            if (timeout != 0L) {
                this._asyncTimeout = timeout;
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void asyncComplete() {
        if (this._isAsync) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
            }
            finally {
                this._asyncFuture.complete((Object)this);
            }
        }
    }

    protected void asyncAwait() throws InterruptedException, ExecutionException, IOException {
        if (this._isAsync) {
            if (this._asyncTimeout > 0L) {
                try {
                    this._asyncFuture.get(this._asyncTimeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    for (ContextAsyncListener listener1 : this._asyncListeners) {
                        listener1.onTimeout((Context)this);
                    }
                }
            } else {
                this._asyncFuture.get();
            }
        }
    }

    protected void innerCommit() throws IOException {
        if (this.getHandled() || this.status() >= 200) {
            this.sendHeaders(true);
        } else {
            this.status(404);
            this.sendHeaders(true);
        }
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            if (isCommit || !this._allows_write) {
                this._exchange.sendResponseHeaders(this.status(), -1L);
            } else {
                Object tmp = this._exchange.getResponseHeaders().get("Content-Length");
                if (tmp != null && tmp.size() > 0) {
                    this._exchange.sendResponseHeaders(this.status(), Long.parseLong((String)tmp.get(0)));
                } else {
                    this._exchange.sendResponseHeaders(this.status(), 0L);
                }
            }
        }
    }
}

