/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.dashscope;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.embedding.Embedding;
import org.noear.solon.ai.embedding.EmbeddingConfig;
import org.noear.solon.ai.embedding.EmbeddingException;
import org.noear.solon.ai.embedding.EmbeddingOptions;
import org.noear.solon.ai.embedding.EmbeddingResponse;
import org.noear.solon.ai.embedding.dialect.AbstractEmbeddingDialect;

public class DashscopeEmbeddingDialect
extends AbstractEmbeddingDialect {
    private static final String URL_PREFIX = "https://dashscope.aliyuncs.com/api/v1/services/";
    private static DashscopeEmbeddingDialect instance = new DashscopeEmbeddingDialect();

    public static DashscopeEmbeddingDialect getInstance() {
        return instance;
    }

    public boolean matched(EmbeddingConfig config) {
        if ("dashscope".equals(config.getProvider())) {
            return true;
        }
        return config.getApiUrl().startsWith(URL_PREFIX);
    }

    public String buildRequestJson(EmbeddingConfig config, EmbeddingOptions options, List<String> input) {
        return new ONode().then(n -> {
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            n.getOrNew("input").getOrNew("texts").then(n1 -> {
                for (String m1 : input) {
                    n1.add((Object)m1);
                }
            });
            n.getOrNew("parameters").then(n1 -> {
                for (Map.Entry kv : options.options().entrySet()) {
                    n1.set((String)kv.getKey(), kv.getValue());
                }
            });
        }).toJson();
    }

    public EmbeddingResponse parseResponseJson(EmbeddingConfig config, String respJson) {
        ONode oResp = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        String model = oResp.get("model").getString();
        if (oResp.hasKey("code") && !Utils.isEmpty((String)oResp.get("code").getString())) {
            return new EmbeddingResponse(model, new EmbeddingException(oResp.get("code").getString() + ": " + oResp.get("message").getString()), null, null);
        }
        ArrayList<Embedding> data = new ArrayList<Embedding>();
        for (ONode n1 : oResp.get("output").get("embeddings").getArray()) {
            int index = 0;
            index = n1.hasKey("text_index") ? n1.get("text_index").getInt().intValue() : n1.get("index").getInt().intValue();
            data.add(new Embedding(index, (float[])n1.get("embedding").toBean(float[].class)));
        }
        AiUsage usage = null;
        if (oResp.hasKey("usage")) {
            ONode oUsage = oResp.get("usage");
            long total_tokens = oUsage.get("total_tokens").getLong();
            usage = new AiUsage(total_tokens, 0L, total_tokens, oUsage);
        }
        return new EmbeddingResponse(model, null, data, usage);
    }
}

