/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.codec.util.DateUtil;
import org.noear.snack4.json.util.IoUtil;
import org.noear.snack4.json.util.NameUtil;

public class JsonWriter {
    private final Options opts;
    private final Writer writer;
    private int depth = 0;
    private final StringBuilder stringBuilder;
    private final boolean Write_BrowserCompatible;
    private final boolean Write_UseRawBackslash;
    private final boolean Write_UseSnakeStyle;
    private final boolean Write_UseCamelStyle;

    public static String write(ONode node, Options opts) throws IOException {
        StringWriter writer = new StringWriter();
        JsonWriter.write(node, opts, writer);
        return writer.toString();
    }

    public static void write(ONode node, Options opts, Writer writer) throws IOException {
        new JsonWriter(opts, writer).write(node);
    }

    private StringBuilder getStringBuilder() {
        this.stringBuilder.setLength(0);
        return this.stringBuilder;
    }

    public JsonWriter(Options opts, Writer writer) {
        Objects.requireNonNull(writer, "writer");
        this.writer = writer;
        this.opts = opts == null ? Options.DEF_OPTIONS : opts;
        this.Write_BrowserCompatible = this.opts.hasFeature(Feature.Write_BrowserCompatible);
        this.Write_UseRawBackslash = this.opts.hasFeature(Feature.Write_UseRawBackslash);
        this.Write_UseSnakeStyle = this.opts.hasFeature(Feature.Write_UseSmlSnakeStyle);
        this.Write_UseCamelStyle = this.opts.hasFeature(Feature.Write_UseSmlCamelStyle);
        this.stringBuilder = this.Write_UseSnakeStyle || this.Write_UseCamelStyle ? new StringBuilder(32) : null;
    }

    public void write(ONode node) throws IOException {
        switch (node.type()) {
            case Object: {
                this.writeObject(node.getObject());
                break;
            }
            case Array: {
                this.writeArray(node.getArray());
                break;
            }
            case String: {
                this.writeString(node.getString());
                break;
            }
            case Number: {
                if (this.opts.hasFeature(Feature.Write_NumbersAsString)) {
                    this.writeString(String.valueOf(node.getValue()));
                    break;
                }
                this.writeNumber(node.getNumber());
                break;
            }
            case Date: {
                if (this.opts.hasFeature(Feature.Write_UseDateFormat)) {
                    this.writeString(DateUtil.format(node.getDate(), this.opts.getDateFormat(), this.opts.getZoneId()));
                    break;
                }
                this.writeNumber(node.getDate().getTime());
                break;
            }
            case Boolean: {
                if (this.opts.hasFeature(Feature.Write_BooleanAsNumber)) {
                    this.writer.write(node.getBoolean() != false ? "1" : "0");
                    break;
                }
                this.writer.write(node.getBoolean() != false ? "true" : "false");
                break;
            }
            case Null: 
            case Undefined: {
                this.writer.write("null");
            }
        }
    }

    private void writeObject(Map<String, ONode> map) throws IOException {
        this.writer.write(123);
        ++this.depth;
        boolean first = true;
        for (Map.Entry<String, ONode> entry : map.entrySet()) {
            if (entry.getValue().isNull() && !this.opts.hasFeature(Feature.Write_Nulls)) continue;
            if (!first) {
                this.writer.write(44);
            }
            this.writeIndentation();
            String key = this.Write_UseSnakeStyle ? NameUtil.toSmlSnakeStyle(this.getStringBuilder(), entry.getKey()) : (this.Write_UseCamelStyle ? NameUtil.toSmlCamelStyle(this.getStringBuilder(), entry.getKey()) : entry.getKey());
            this.writeKey(key);
            this.writer.write(58);
            if (this.opts.hasFeature(Feature.Write_PrettyFormat)) {
                this.writer.write(32);
            }
            this.write(entry.getValue());
            first = false;
        }
        --this.depth;
        this.writeIndentation();
        this.writer.write(125);
    }

    private void writeArray(List<ONode> list) throws IOException {
        this.writer.write(91);
        ++this.depth;
        boolean first = true;
        for (ONode item : list) {
            if (!first) {
                this.writer.write(44);
            }
            this.writeIndentation();
            this.write(item);
            first = false;
        }
        --this.depth;
        this.writeIndentation();
        this.writer.write(93);
    }

    private void writeIndentation() throws IOException {
        if (this.opts.hasFeature(Feature.Write_PrettyFormat)) {
            this.writer.write(10);
            for (int i = 0; i < this.depth; ++i) {
                this.writer.write(this.opts.getWriteIndent());
            }
        }
    }

    private void writeNumber(Number num) throws IOException {
        if (this.opts.hasFeature(Feature.Write_DoubleAsString) && num instanceof Double) {
            this.writer.write(34);
            this.writer.write(num.toString());
            this.writer.write(34);
            return;
        }
        if (this.opts.hasFeature(Feature.Write_LongAsString) && num instanceof Long) {
            this.writer.write(34);
            this.writer.write(num.toString());
            this.writer.write(34);
            return;
        }
        if (this.opts.hasFeature(Feature.Write_BigDecimalAsPlain) && num instanceof BigDecimal) {
            this.writer.write(34);
            this.writer.write(((BigDecimal)num).toPlainString());
            this.writer.write(34);
            return;
        }
        this.writer.write(num.toString());
        if (this.opts.hasFeature(Feature.Write_NumberTypeSuffix)) {
            if (num instanceof Double) {
                this.writer.write(68);
            } else if (num instanceof Float) {
                this.writer.write(70);
            } else if (num instanceof Long) {
                this.writer.write(76);
            }
        }
    }

    private void writeKey(String s) throws IOException {
        if (this.opts.hasFeature(Feature.Write_UnquotedFieldNames)) {
            this.writeEscapeString(s, '\"', this.opts);
        } else {
            this.writeString(s);
        }
    }

    private void writeString(String s) throws IOException {
        char quoteChar = this.opts.hasFeature(Feature.Write_UseSingleQuotes) ? (char)'\'' : '\"';
        this.writer.write(quoteChar);
        this.writeEscapeString(s, quoteChar, this.opts);
        this.writer.write(quoteChar);
    }

    private void writeEscapeString(String s, char quoteChar, Options opts) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == quoteChar || c == '\n' || c == '\r' || c == '\t' || c == '\f' || c == '\b') {
                this.writer.write(92);
                this.writer.write(IoUtil.CHARS_MARK[c]);
                continue;
            }
            if (c == '\\') {
                if (this.Write_UseRawBackslash) {
                    this.writer.write(92);
                    continue;
                }
                this.writer.write("\\\\");
                continue;
            }
            if (c < ' ') {
                this.writer.append('\\');
                this.writer.append('u');
                this.writer.append('0');
                this.writer.append('0');
                this.writer.append(IoUtil.DIGITS[c >>> 4 & 0xF]);
                this.writer.append(IoUtil.DIGITS[c & 0xF]);
                continue;
            }
            if (c == '\u007f') {
                this.writeEscapeChar(c);
                continue;
            }
            if (c > '\u007f' && this.Write_BrowserCompatible) {
                this.writeEscapeChar(c);
                continue;
            }
            this.writer.write(c);
        }
    }

    private void writeEscapeChar(int c) throws IOException {
        this.writer.append('\\');
        this.writer.append('u');
        this.writer.append(IoUtil.DIGITS[c >>> 12 & 0xF]);
        this.writer.append(IoUtil.DIGITS[c >>> 8 & 0xF]);
        this.writer.append(IoUtil.DIGITS[c >>> 4 & 0xF]);
        this.writer.append(IoUtil.DIGITS[c & 0xF]);
    }
}

