/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.json.JsonParseException;
import org.noear.snack4.json.util.IoUtil;
import org.noear.snack4.json.util.NameUtil;

public class JsonReader {
    private final Options opts;
    private final ParserState state;
    private final StringBuilder stringBuilder;
    private final boolean Read_AllowComment;
    private final boolean Read_DisableUnquotedKeys;
    private final boolean Read_DisableSingleQuotes;
    private final boolean Read_UnwrapJsonString;
    private final boolean Read_ConvertSnakeToCamel;
    private final boolean Read_ConvertCamelToSnake;

    public static ONode read(String json) throws IOException {
        return JsonReader.read(json, null);
    }

    public static ONode read(String json, Options opts) throws IOException {
        return new JsonReader(new StringReader(json), opts).read();
    }

    public static ONode read(Reader reader) throws IOException {
        return new JsonReader(reader, null).read();
    }

    public static ONode read(Reader reader, Options opts) throws IOException {
        return new JsonReader(reader, opts).read();
    }

    private StringBuilder getStringBuilder() {
        this.stringBuilder.setLength(0);
        return this.stringBuilder;
    }

    public JsonReader(Reader reader) {
        this(reader, null);
    }

    public JsonReader(Reader reader, Options opts) {
        Objects.requireNonNull(reader, "reader");
        this.state = new ParserState(reader);
        this.opts = opts == null ? Options.DEF_OPTIONS : opts;
        this.stringBuilder = new StringBuilder(32);
        this.Read_AllowComment = this.opts.hasFeature(Feature.Read_AllowComment);
        this.Read_DisableUnquotedKeys = this.opts.hasFeature(Feature.Read_DisableUnquotedKeys);
        this.Read_DisableSingleQuotes = this.opts.hasFeature(Feature.Read_DisableSingleQuotes);
        this.Read_UnwrapJsonString = this.opts.hasFeature(Feature.Read_UnwrapJsonString);
        this.Read_ConvertSnakeToCamel = this.opts.hasFeature(Feature.Read_ConvertSnakeToSmlCamel);
        this.Read_ConvertCamelToSnake = this.opts.hasFeature(Feature.Read_ConvertCamelToSmlSnake);
    }

    public ONode read() throws IOException {
        try {
            this.state.fillBuffer();
            ONode node = this.parseValue();
            this.state.skipWhitespace();
            if (this.Read_AllowComment) {
                this.state.skipComments();
            }
            if (this.state.bufferPosition < this.state.bufferLimit) {
                throw this.state.error("Unexpected data after json root");
            }
            ONode oNode = node;
            return oNode;
        }
        finally {
            this.state.reader.close();
        }
    }

    private ONode parseValue() throws IOException {
        char c;
        this.state.skipWhitespace();
        if (this.Read_AllowComment) {
            this.state.skipComments();
        }
        if ((c = this.state.peekChar()) == '{') {
            return this.parseObject();
        }
        if (c == '[') {
            return this.parseArray();
        }
        if (c == '\"' || !this.Read_DisableSingleQuotes && c == '\'') {
            String str = this.parseString();
            if (this.Read_UnwrapJsonString && str.length() > 1) {
                char c1 = str.charAt(0);
                char c2 = str.charAt(str.length() - 1);
                if (c1 == '{' && c2 == '}' || c1 == '[' && c2 == ']') {
                    return ONode.ofJson(str, this.opts);
                }
            }
            return new ONode(this.opts, str);
        }
        if (c == 'n' && this.state.peekChar(1) == 'e' && this.state.peekChar(2) == 'w') {
            return this.parseDate();
        }
        if (c == '-' || c >= '0' && c <= '9') {
            return new ONode(this.opts, this.parseNumber());
        }
        if (c == 't') {
            return this.parseKeyword("true", true);
        }
        if (c == 'f') {
            return this.parseKeyword("false", false);
        }
        if (c == 'n') {
            return this.parseKeyword("null", null);
        }
        if (c == 'N') {
            return this.parseKeyword("NaN", null);
        }
        if (c == 'u') {
            return this.parseKeyword("undefined", null);
        }
        throw this.state.error("Unexpected character: " + c);
    }

    private ONode parseDate() throws IOException {
        this.state.expect('n');
        this.state.expect('e');
        this.state.expect('w');
        this.state.skipWhitespace();
        this.state.expect('D');
        this.state.expect('a');
        this.state.expect('t');
        this.state.expect('e');
        this.state.expect('(');
        this.state.skipWhitespace();
        Number number = this.parseNumber();
        long timestamp = number instanceof Long ? ((Long)number).longValue() : number.longValue();
        this.state.skipWhitespace();
        this.state.expect(')');
        return new ONode(this.opts, new Date(timestamp));
    }

    private ONode parseObject() throws IOException {
        Map map;
        block3: {
            map = this.opts.createMap();
            this.state.expect('{');
            while (true) {
                this.state.skipWhitespace();
                if (this.state.peekChar() == '}') break block3;
                String key = this.parseKey();
                if (key.isEmpty() && !this.opts.hasFeature(Feature.Read_AllowEmptyKeys)) {
                    throw new JsonParseException("Empty key is not allowed");
                }
                this.state.skipWhitespace();
                this.state.expect(':');
                ONode value = this.parseValue();
                map.put(key, value);
                this.state.skipWhitespace();
                if (this.state.peekChar() == ',') {
                    this.state.bufferPosition++;
                    this.state.skipWhitespace();
                    if (this.state.peekChar() != '}') continue;
                    throw this.state.error("Trailing comma in object");
                }
                if (this.state.peekChar() != '}') break;
            }
            throw this.state.error("Expected ',' or '}'");
        }
        this.state.bufferPosition++;
        return new ONode(this.opts, map);
    }

    private String parseKey() throws IOException {
        char c;
        String key = !this.Read_DisableUnquotedKeys ? ((c = this.state.peekChar()) != '\"' && c != '\'' ? this.parseUnquotedString() : this.parseString()) : this.parseString();
        if (this.Read_ConvertSnakeToCamel) {
            key = NameUtil.toSmlCamelStyle(this.getStringBuilder(), key);
        } else if (this.Read_ConvertCamelToSnake) {
            key = NameUtil.toSmlSnakeStyle(this.getStringBuilder(), key);
        }
        return key;
    }

    private String parseUnquotedString() throws IOException {
        char c;
        StringBuilder sb = this.getStringBuilder();
        while ((c = this.state.peekChar()) != ':' && c != ',' && c != '}' && c != ']' && !Character.isWhitespace(c)) {
            sb.append(this.state.nextChar());
        }
        return sb.toString();
    }

    private ONode parseArray() throws IOException {
        List list;
        block2: {
            list = this.opts.createList();
            this.state.expect('[');
            while (true) {
                this.state.skipWhitespace();
                if (this.state.peekChar() == ']') break block2;
                list.add(this.parseValue());
                this.state.skipWhitespace();
                if (this.state.peekChar() == ',') {
                    this.state.bufferPosition++;
                    this.state.skipWhitespace();
                    if (this.state.peekChar() != ']') continue;
                    throw this.state.error("Trailing comma in array");
                }
                if (this.state.peekChar() != ']') break;
            }
            throw this.state.error("Expected ',' or ']'");
        }
        this.state.bufferPosition++;
        return new ONode(this.opts, list);
    }

    private String parseString() throws IOException {
        char quoteChar = this.state.nextChar();
        if (quoteChar != '\"' && (this.Read_DisableSingleQuotes || quoteChar != '\'')) {
            throw this.state.error("Expected string to start with a quote");
        }
        StringBuilder sb = this.getStringBuilder();
        block10: while (true) {
            int start;
            char c;
            int end;
            if (this.state.bufferPosition >= this.state.bufferLimit && !this.state.fillBuffer()) {
                throw this.state.error("Unclosed string");
            }
            for (end = start = this.state.bufferPosition; end < this.state.bufferLimit && (c = this.state.buffer[end]) != quoteChar && c != '\\' && c >= ' '; ++end) {
            }
            if (end > start) {
                sb.append(this.state.buffer, start, end - start);
            }
            this.state.bufferPosition = end;
            if (this.state.bufferPosition == this.state.bufferLimit) continue;
            c = this.state.nextChar();
            if (c == quoteChar) break;
            if (c == '\\') {
                c = this.state.nextChar();
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sb.append(c);
                        continue block10;
                    }
                    case '/': {
                        sb.append('/');
                        continue block10;
                    }
                    case 'b': {
                        sb.append('\b');
                        continue block10;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block10;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block10;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block10;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block10;
                    }
                    case 'u': {
                        int val = 0;
                        for (int i = 0; i < 4; ++i) {
                            char hex_char = this.state.nextChar();
                            val <<= 4;
                            if (hex_char >= '0' && hex_char <= '9') {
                                val += hex_char - 48;
                                continue;
                            }
                            if (hex_char >= 'a' && hex_char <= 'f') {
                                val += hex_char - 97 + 10;
                                continue;
                            }
                            if (hex_char >= 'A' && hex_char <= 'F') {
                                val += hex_char - 65 + 10;
                                continue;
                            }
                            throw this.state.error("Invalid Unicode escape");
                        }
                        sb.append((char)val);
                        continue block10;
                    }
                }
                if (c >= '0' && c <= '7') {
                    sb.append(IoUtil.CHARS_MARK_REV[c]);
                    continue;
                }
                if (this.opts.hasFeature(Feature.Read_AllowInvalidEscapeCharacter)) {
                    sb.append(c);
                    continue;
                }
                if (this.opts.hasFeature(Feature.Read_AllowBackslashEscapingAnyCharacter)) {
                    sb.append('\\').append(c);
                    continue;
                }
                throw this.state.error("Invalid escape character: \\" + c);
            }
            if (c < ' ') {
                if (!this.opts.hasFeature(Feature.Read_AllowUnescapedControlCharacters)) {
                    throw this.state.error("Unescaped control character: 0x" + Integer.toHexString(c));
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Number parseNumber() throws IOException {
        StringBuilder sb = this.getStringBuilder();
        char c = this.state.peekChar();
        if (c == '-') {
            sb.append(this.state.nextChar());
        }
        if (!this.opts.hasFeature(Feature.Read_AllowZeroLeadingNumbers) && this.state.peekChar() == '0') {
            sb.append(this.state.nextChar());
            if (this.isDigit(this.state.peekChar())) {
                throw this.state.error("Leading zeros not allowed");
            }
        }
        if (this.isDigit(this.state.peekChar())) {
            while (this.isDigit(this.state.peekChar())) {
                sb.append(this.state.nextChar());
            }
        } else if (sb.length() == 0) {
            throw this.state.error("Invalid number format");
        }
        if (this.state.peekChar() == '.') {
            sb.append(this.state.nextChar());
            if (!this.isDigit(this.state.peekChar())) {
                throw this.state.error("Invalid decimal format");
            }
            while (this.isDigit(this.state.peekChar())) {
                sb.append(this.state.nextChar());
            }
        }
        if (this.state.peekChar() == 'e' || this.state.peekChar() == 'E') {
            sb.append(this.state.nextChar());
            if (this.state.peekChar() == '+' || this.state.peekChar() == '-') {
                sb.append(this.state.nextChar());
            }
            if (!this.isDigit(this.state.peekChar())) {
                throw this.state.error("Invalid exponent format");
            }
            while (this.isDigit(this.state.peekChar())) {
                sb.append(this.state.nextChar());
            }
        }
        char postfix = '\u0000';
        if (this.state.peekChar() == 'L' || this.state.peekChar() == 'F' || this.state.peekChar() == 'D' || this.state.peekChar() == 'M') {
            postfix = this.state.nextChar();
        }
        String numStr = sb.toString();
        try {
            if (postfix == 'D') {
                return Double.parseDouble(numStr);
            }
            if (postfix == 'F') {
                return Float.valueOf(Float.parseFloat(numStr));
            }
            if (postfix == 'L') {
                return Long.parseLong(numStr);
            }
            if (numStr.indexOf(46) >= 0 || numStr.indexOf(101) >= 0 || numStr.indexOf(69) >= 0) {
                if (numStr.length() > 19 || this.opts.hasFeature(Feature.Read_UseBigDecimalMode)) {
                    return new BigDecimal(numStr);
                }
                return Double.parseDouble(numStr);
            }
            if (numStr.length() > 19 || this.opts.hasFeature(Feature.Read_UseBigIntegerMode)) {
                return new BigInteger(numStr);
            }
            long longVal = Long.parseLong(numStr);
            if (longVal <= Integer.MAX_VALUE && longVal >= Integer.MIN_VALUE) {
                return (int)longVal;
            }
            return longVal;
        }
        catch (NumberFormatException e) {
            throw this.state.error("Invalid number: " + numStr);
        }
    }

    private ONode parseKeyword(String expect, Object value) throws IOException {
        for (int i = 0; i < expect.length(); ++i) {
            char expectedChar = expect.charAt(i);
            char actualChar = this.state.nextChar();
            if (actualChar == expectedChar) continue;
            throw this.state.error("Unexpected keyword: expected '" + expect + "'");
        }
        return new ONode(this.opts, value);
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static class ParserState {
        private static final int BUFFER_SIZE = 8192;
        private final Reader reader;
        private long line = 1L;
        private long column = 0L;
        private final char[] buffer = new char[8192];
        private int bufferPosition;
        private int bufferLimit;

        public ParserState(Reader reader) {
            this.reader = reader;
        }

        private char nextChar() throws IOException {
            char c;
            if (this.bufferPosition >= this.bufferLimit && !this.fillBuffer()) {
                throw this.error("Unexpected end of input");
            }
            if ((c = this.buffer[this.bufferPosition++]) == '\n') {
                ++this.line;
                this.column = 0L;
            } else if (c == '\r') {
                if (this.peekChar() == '\n') {
                    ++this.bufferPosition;
                }
                ++this.line;
                this.column = 0L;
            } else {
                ++this.column;
            }
            return c;
        }

        private char peekChar() throws IOException {
            return this.peekChar(0);
        }

        private char peekChar(int offset) throws IOException {
            if (this.bufferPosition + offset >= this.bufferLimit && !this.fillBuffer()) {
                return '\u0000';
            }
            return this.bufferPosition + offset < this.bufferLimit ? this.buffer[this.bufferPosition + offset] : (char)'\u0000';
        }

        private boolean fillBuffer() throws IOException {
            if (this.bufferPosition < this.bufferLimit) {
                return true;
            }
            this.bufferLimit = this.reader.read(this.buffer);
            this.bufferPosition = 0;
            return this.bufferLimit > 0;
        }

        private void expect(char expected) throws IOException {
            char c = this.nextChar();
            if (c != expected) {
                throw this.error("Expected '" + expected + "' but found '" + c + "'");
            }
        }

        private JsonParseException error(String message) {
            return new JsonParseException(message + " at line " + this.line + " column " + this.column);
        }

        private void skipWhitespace() throws IOException {
            while (true) {
                if (this.bufferPosition >= this.bufferLimit && !this.fillBuffer()) {
                    return;
                }
                char c = this.buffer[this.bufferPosition];
                if (c >= ' ' && c != ' ' && c != '\t' && c != '\n' && c != '\r') break;
                this.nextChar();
            }
        }

        private void skipComments() throws IOException {
            char c = this.peekChar();
            if (c == '/') {
                ++this.bufferPosition;
                char next = this.peekChar();
                if (next == '/') {
                    this.skipLineComment();
                } else if (next == '*') {
                    this.skipBlockComment();
                }
            }
        }

        private void skipLineComment() throws IOException {
            while (this.bufferPosition < this.bufferLimit || this.fillBuffer()) {
                char c = this.buffer[this.bufferPosition];
                if (c == '\n') {
                    ++this.line;
                    this.column = 0L;
                    ++this.bufferPosition;
                    break;
                }
                ++this.bufferPosition;
                ++this.column;
            }
        }

        private void skipBlockComment() throws IOException {
            ++this.bufferPosition;
            boolean closed = false;
            while (this.bufferPosition < this.bufferLimit || this.fillBuffer()) {
                char c;
                if ((c = this.buffer[this.bufferPosition++]) == '\n') {
                    ++this.line;
                    this.column = 0L;
                } else if (c == '\r') {
                    if (this.peekChar() == '\n') {
                        ++this.bufferPosition;
                    }
                    ++this.line;
                    this.column = 0L;
                } else {
                    ++this.column;
                }
                if (c != '*' || this.peekChar() != '/') continue;
                ++this.bufferPosition;
                closed = true;
                break;
            }
            if (!closed) {
                throw this.error("Unclosed block comment");
            }
        }
    }
}

