/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.util;

import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.codec.CodecException;
import org.noear.snack4.codec.DecodeContext;
import org.noear.snack4.util.Asserts;

public class DateUtil {
    private static final ZoneId SYSTEM_ZONE = Options.DEF_ZONE;
    private static final Map<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>();
    private static final Map<Integer, List<DateTimeFormatter>> LENGTH_BUCKETS = new HashMap<Integer, List<DateTimeFormatter>>();
    private static final List<DateTimeFormatter> VARIABLE_FORMATTERS = new ArrayList<DateTimeFormatter>();
    private static final DateTimeFormatter[] COMMON_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_ZONED_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ISO_TIME, DateTimeFormatter.RFC_1123_DATE_TIME};
    private static final String[] PATTERNS;

    private static boolean isVariableLength(String pattern) {
        String clean = pattern.replaceAll("'[^']*'", "");
        return clean.matches(".*\\b[Mdhms]\\b.*") || clean.contains("-M-") || clean.contains("/M/") || clean.contains(".M.") || clean.contains("-d") || clean.contains("/d") || clean.contains(".d");
    }

    public static Date parseTry(String dateStr) {
        try {
            return DateUtil.parse(dateStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parse(String dateStr) throws ParseException {
        if (dateStr == null) {
            return null;
        }
        String trimmed = dateStr.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        int len = trimmed.length();
        Date result = DateUtil.parseFast(trimmed, len);
        if (result != null) {
            return result;
        }
        result = DateUtil.parseSpecial(trimmed, len);
        if (result != null) {
            return result;
        }
        result = DateUtil.parseSmart(trimmed);
        if (result != null) {
            return result;
        }
        result = DateUtil.parseFormatters(trimmed, len);
        if (result != null) {
            return result;
        }
        if (DateUtil.isNumeric(trimmed)) {
            return DateUtil.parseTimestamp(trimmed);
        }
        throw new ParseException("Unsupported date format: " + trimmed, 0);
    }

    private static Date parseFast(String s, int len) {
        try {
            switch (len) {
                case 19: {
                    if (s.charAt(4) != '-' || s.charAt(7) != '-') break;
                    if (s.charAt(10) == ' ') {
                        return Date.from(LocalDateTime.of((s.charAt(0) - 48) * 1000 + (s.charAt(1) - 48) * 100 + (s.charAt(2) - 48) * 10 + (s.charAt(3) - 48), (s.charAt(5) - 48) * 10 + (s.charAt(6) - 48), (s.charAt(8) - 48) * 10 + (s.charAt(9) - 48), (s.charAt(11) - 48) * 10 + (s.charAt(12) - 48), (s.charAt(14) - 48) * 10 + (s.charAt(15) - 48), (s.charAt(17) - 48) * 10 + (s.charAt(18) - 48)).atZone(SYSTEM_ZONE).toInstant());
                    }
                    if (s.charAt(10) != 'T') break;
                    return DateUtil.parseWithFormatter(s, DateUtil.getFormatter("yyyy-MM-dd'T'HH:mm:ss"));
                }
                case 10: {
                    if (s.charAt(4) != '-' || s.charAt(7) != '-') break;
                    return Date.from(LocalDate.of((s.charAt(0) - 48) * 1000 + (s.charAt(1) - 48) * 100 + (s.charAt(2) - 48) * 10 + (s.charAt(3) - 48), (s.charAt(5) - 48) * 10 + (s.charAt(6) - 48), (s.charAt(8) - 48) * 10 + (s.charAt(9) - 48)).atStartOfDay(SYSTEM_ZONE).toInstant());
                }
                case 8: 
                case 14: {
                    if (!DateUtil.isNumeric(s)) break;
                    return DateUtil.parseWithFormatter(s, DateUtil.getFormatter(len == 14 ? "yyyyMMddHHmmss" : "yyyyMMdd"));
                }
                case 23: {
                    if (s.charAt(10) == 'T') {
                        return DateUtil.parseWithFormatter(s, DateUtil.getFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS"));
                    }
                    if (s.charAt(19) == ',') {
                        return DateUtil.parseWithFormatter(s, DateUtil.getFormatter("yyyy-MM-dd HH:mm:ss,SSS"));
                    }
                    if (s.charAt(19) != '.') break;
                    return DateUtil.parseWithFormatter(s, DateUtil.getFormatter("yyyy-MM-dd HH:mm:ss.SSS"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Date parseSpecial(String s, int len) throws ParseException {
        if (len == 22 && (s.charAt(17) == '+' || s.charAt(17) == '-') && DateUtil.isNumeric(s.substring(0, 17))) {
            try {
                return Date.from(OffsetDateTime.of(DateUtil.parseInt(s, 0, 4), DateUtil.parseInt(s, 4, 6), DateUtil.parseInt(s, 6, 8), DateUtil.parseInt(s, 8, 10), DateUtil.parseInt(s, 10, 12), DateUtil.parseInt(s, 12, 14), DateUtil.parseInt(s, 14, 17) * 1000000, ZoneOffset.of(s.substring(17).length() == 5 ? s.substring(17, 20) + ":" + s.substring(20) : s.substring(17))).toInstant());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s.indexOf(26102) > 0 || s.indexOf(20998) > 0) {
            try {
                String[] parts = s.split("[\u65f6\u5206\u79d2]");
                if (parts.length >= 3) {
                    LocalTime time = LocalTime.of(DateUtil.parseInt(parts[0]), DateUtil.parseInt(parts[1]), DateUtil.parseInt(parts[2]));
                    return Date.from(LocalDateTime.of(LocalDate.now(), time).atZone(SYSTEM_ZONE).toInstant());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Date parseSmart(String s) throws ParseException {
        Date result;
        if (s.indexOf(84) > 0) {
            try {
                if (s.endsWith("Z") && s.contains("+")) {
                    String cleaned = s.substring(0, s.length() - 1);
                    return Date.from(OffsetDateTime.parse(cleaned).toInstant());
                }
                if (s.indexOf(90) > 0) {
                    return Date.from(Instant.parse(s));
                }
                if (s.indexOf(43) > 0 || s.indexOf(45) > 0) {
                    return Date.from(OffsetDateTime.parse(s).toInstant());
                }
            }
            catch (Exception cleaned) {
                // empty catch block
            }
        }
        if (s.indexOf(58) > 0 && (result = DateUtil.parseTime(s)) != null) {
            return result;
        }
        if ((s.indexOf(45) > 0 || s.indexOf(47) > 0 || s.indexOf(46) > 0) && (result = DateUtil.parseVariableDate(s)) != null) {
            return result;
        }
        return null;
    }

    private static Date parseTime(String s) throws ParseException {
        try {
            String normalized = s;
            int dotIdx = s.indexOf(46);
            if (dotIdx > 0) {
                int end;
                for (end = dotIdx + 1; end < s.length() && Character.isDigit(s.charAt(end)); ++end) {
                }
                int fractionLen = end - dotIdx - 1;
                if (fractionLen > 3 && fractionLen <= 6) {
                    normalized = s.substring(0, dotIdx + 4) + s.substring(end);
                } else if (fractionLen > 6) {
                    throw new ParseException("Fraction seconds too long", 0);
                }
            }
            if (normalized.contains("+") || normalized.contains("-")) {
                try {
                    return Date.from(OffsetDateTime.parse(LocalDate.now() + "T" + normalized).toInstant());
                }
                catch (Exception e) {
                    LocalTime time = LocalTime.parse(normalized, DateUtil.getFormatter("HH:mm:ss.SSS+HH:mm"));
                    return Date.from(LocalDateTime.of(LocalDate.now(), time).atZone(SYSTEM_ZONE).toInstant());
                }
            }
            DateTimeFormatter fmt = normalized.contains(".") ? DateUtil.getFormatter("HH:mm:ss.SSS") : DateUtil.getFormatter("HH:mm:ss");
            LocalTime time = LocalTime.parse(normalized, fmt);
            return Date.from(LocalDateTime.of(LocalDate.of(1970, 1, 1), time).atZone(SYSTEM_ZONE).toInstant());
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Date parseVariableDate(String s) {
        try {
            String normalized = s.replace('/', '-').replace('.', '-');
            String[] parts = normalized.split(" ", 2);
            String[] dateParts = parts[0].split("-");
            if (dateParts.length == 3) {
                int year = DateUtil.parseInt(dateParts[0]);
                int month = DateUtil.parseInt(dateParts[1]);
                int day = DateUtil.parseInt(dateParts[2]);
                if (month < 1 || month > 12 || day < 1 || day > 31) {
                    throw new ParseException("Invalid date", 0);
                }
                StringBuilder std = new StringBuilder().append(dateParts[0]).append('-').append(String.format("%02d", month)).append('-').append(String.format("%02d", day));
                if (parts.length > 1) {
                    int second;
                    String[] timeParts = parts[1].split(":");
                    int hour = DateUtil.parseInt(timeParts[0]);
                    int minute = timeParts.length > 1 ? DateUtil.parseInt(timeParts[1]) : 0;
                    int n = second = timeParts.length > 2 ? DateUtil.parseInt(timeParts[2]) : 0;
                    if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0 || second > 59) {
                        throw new ParseException("Invalid time", 0);
                    }
                    std.append(" ").append(String.format("%02d", hour)).append(":").append(String.format("%02d", minute)).append(":").append(String.format("%02d", second));
                }
                return DateUtil.parseFormatters(std.toString(), std.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Date parseFormatters(String s, int len) {
        Date result;
        for (DateTimeFormatter fmt : COMMON_FORMATTERS) {
            Date result2 = DateUtil.parseWithFormatter(s, fmt);
            if (result2 == null) continue;
            return result2;
        }
        List<DateTimeFormatter> bucket = LENGTH_BUCKETS.get(len);
        if (bucket != null) {
            for (DateTimeFormatter fmt : bucket) {
                result = DateUtil.parseWithFormatter(s, fmt);
                if (result == null) continue;
                return result;
            }
        }
        for (DateTimeFormatter fmt : VARIABLE_FORMATTERS) {
            result = DateUtil.parseWithFormatter(s, fmt);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Date parseWithFormatter(String s, DateTimeFormatter fmt) {
        Instant instant = DateUtil.parseWithFormatter(s, fmt, SYSTEM_ZONE);
        if (instant != null) {
            return Date.from(instant);
        }
        return null;
    }

    private static Instant parseWithFormatter(String s, DateTimeFormatter fmt, ZoneId zoneId) {
        try {
            TemporalAccessor accessor = fmt.parse(s);
            if (accessor.isSupported(ChronoField.OFFSET_SECONDS) || accessor.isSupported(ChronoField.INSTANT_SECONDS)) {
                return Instant.from(accessor);
            }
            if (accessor.isSupported(ChronoField.YEAR) && accessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                return LocalDateTime.from(accessor).atZone(zoneId).toInstant();
            }
            if (accessor.isSupported(ChronoField.DAY_OF_MONTH)) {
                return LocalDate.from(accessor).atStartOfDay(zoneId).toInstant();
            }
            if (accessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                return LocalDate.of(1970, 1, 1).atTime(LocalTime.from(accessor)).atZone(zoneId).toInstant();
            }
            return Instant.from(accessor);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Date parseTimestamp(String s) throws ParseException {
        try {
            long ts = Long.parseLong(s);
            return new Date(s.length() <= 10 ? ts * 1000L : ts);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid timestamp: " + s, 0);
        }
    }

    private static int parseInt(String s) {
        return DateUtil.parseInt(s, 0, s.length());
    }

    private static int parseInt(CharSequence s, int start, int end) {
        int result = 0;
        for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                throw new NumberFormatException("Invalid digit: " + c);
            }
            result = result * 10 + (c - 48);
        }
        return result;
    }

    private static boolean isNumeric(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) >= '0' && s.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    private static DateTimeFormatter getFormatter(String pattern) {
        return FORMATTER_CACHE.computeIfAbsent(pattern, p -> DateTimeFormatter.ofPattern(p).withZone(SYSTEM_ZONE));
    }

    public static String format(Date date, String pattern) {
        return date == null || pattern == null ? null : DateUtil.getFormatter(pattern).format(date.toInstant());
    }

    public static String format(Date date, String pattern, ZoneId zoneId) {
        return date == null || pattern == null ? null : DateUtil.getFormatter(pattern).withZone(zoneId).format(date.toInstant());
    }

    public static String format(Date date, String pattern, TimeZone timeZone) {
        return date == null || pattern == null ? null : DateUtil.getFormatter(pattern).withZone(timeZone.toZoneId()).format(date.toInstant());
    }

    public static String toISOString(Date date) {
        return date == null ? null : DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneId.of("UTC")).format(date.toInstant());
    }

    public static String toGmtString(Date date) {
        return date == null ? null : DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.of("GMT")).format(date.toInstant());
    }

    public static ZoneId zoneIdOf(DecodeContext ctx) {
        ZoneId zoneId = ctx.getOptions().getZoneId();
        if (ctx.getAttr() != null && ctx.getAttr().getZoneId() != null) {
            zoneId = ctx.getAttr().getZoneId();
        }
        return zoneId;
    }

    public static ZonedDateTime decodeAndZone(DecodeContext ctx, ONode node) {
        ZoneId zoneId = DateUtil.zoneIdOf(ctx);
        return DateUtil.decode(ctx, node).atZone(zoneId);
    }

    public static Instant decode(DecodeContext ctx, ONode node) {
        if (node.isDate()) {
            return Instant.ofEpochMilli(node.getDate().getTime());
        }
        if (node.isNumber()) {
            return Instant.ofEpochMilli(node.getLong());
        }
        if (node.isString()) {
            try {
                DateTimeFormatter formatter;
                if (ctx.getAttr() != null && Asserts.isNotEmpty(ctx.getAttr().getFormat()) && (formatter = DateUtil.getFormatter(ctx.getAttr().getFormat())) != null) {
                    ZoneId zoneId = ctx.getAttr().getZoneId();
                    if (zoneId == null) {
                        zoneId = SYSTEM_ZONE;
                    }
                    Instant instant = DateUtil.parseWithFormatter(node.getString(), formatter, zoneId);
                    return instant;
                }
                return DateUtil.parse(node.getString()).toInstant();
            }
            catch (Exception ex) {
                throw new CodecException("Cannot be converted to " + ctx.getType().getSimpleName() + ": " + node, ex);
            }
        }
        throw new CodecException("Cannot be converted to " + ctx.getType().getSimpleName() + ": " + node);
    }

    static {
        for (String pattern : PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss,SSS", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy.MM.dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm", "yyyy/MM/dd HH:mm", "yyyy.MM.dd HH:mm", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd", "yyyy-M-d H:m:s", "yyyy/M/d H:m:s", "yyyy.M.d H:m:s", "yyyy-M-d", "yyyy/M/d", "yyyy.M.d", "yyyyMMddHHmmssSSSZ", "yyyyMMddHHmmssSSS", "yyyyMMddHHmmss", "yyyyMMdd", "yyyy-MM-dd'T'HH:mm:ss+HH:mm", "HH:mm:ss", "HH:mm:ss.SSS", "HH:mm:ss.SSSSSS", "HH:mm:ssXXX", "HH:mm:ss.SSS+HH:mm", "HH\u65f6mm\u5206ss\u79d2", "H:m:s", "H:m"}) {
            DateTimeFormatter fmt = DateUtil.getFormatter(pattern);
            if (DateUtil.isVariableLength(pattern)) {
                VARIABLE_FORMATTERS.add(fmt);
                continue;
            }
            int len = pattern.replace("'", "").length();
            LENGTH_BUCKETS.computeIfAbsent(len, k -> new ArrayList()).add(fmt);
        }
    }
}

