/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.encode;

import org.noear.eggg.FieldEggg;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.annotation.ONodeAttrHolder;
import org.noear.snack4.codec.EncodeContext;
import org.noear.snack4.codec.ObjectPatternEncoder;
import org.noear.snack4.codec.util.EgggUtil;
import org.noear.snack4.codec.util.EnumWrap;

public class _EnumPatternEncoder
implements ObjectPatternEncoder<Enum> {
    @Override
    public boolean canEncode(Object value) {
        return value instanceof Enum;
    }

    @Override
    public ONode encode(EncodeContext ctx, Enum value, ONode target) {
        EnumWrap ew = EnumWrap.from(value.getClass());
        Object o = ew.getCustomValue(value);
        if (o != null) {
            return target.setValue(o);
        }
        if (ctx.hasFeature(Feature.Write_EnumShapeAsObject)) {
            for (FieldEggg fe : EgggUtil.getClassEggg(value.getClass()).getAllFieldEgggs()) {
                if (fe.isStatic() || fe.isTransient() || !((ONodeAttrHolder)fe.getDigest()).isEncode() || fe.getField().getDeclaringClass() == Enum.class) continue;
                target.set(fe.getAlias(), fe.getValue((Object)value));
            }
            if (target.isObject()) {
                return target;
            }
        }
        if (ctx.hasFeature(Feature.Write_EnumUsingToString)) {
            return target.setValue(value.toString());
        }
        if (ctx.hasFeature(Feature.Write_EnumUsingName)) {
            return target.setValue(value.name());
        }
        return target.setValue(value.ordinal());
    }
}

