/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.encode;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.codec.EncodeContext;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.snack4.util.Asserts;

public class LocalDateTimeEncoder
implements ObjectEncoder<LocalDateTime> {
    @Override
    public ONode encode(EncodeContext ctx, LocalDateTime value, ONode target) {
        if (ctx.getAttr() != null && Asserts.isNotEmpty(ctx.getAttr().getFormat())) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(ctx.getAttr().getFormat());
            return target.setValue(formatter.format(value));
        }
        Instant it = value.atZone(Options.DEF_TIME_ZONE.toZoneId()).toInstant();
        return target.setValue(new Date(it.getEpochSecond() * 1000L + (long)(it.getNano() / 1000000)));
    }
}

