/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.decode;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.DecodeContext;
import org.noear.snack4.codec.ObjectPatternDecoder;
import org.noear.snack4.codec.util.ClassUtil;

public class _PropertiesPatternDecoder
implements ObjectPatternDecoder<Properties> {
    @Override
    public boolean canDecode(Class<?> clazz) {
        return Properties.class.isAssignableFrom(clazz);
    }

    @Override
    public Properties decode(DecodeContext<Properties> ctx, ONode node) {
        Properties p = ctx.getTarget();
        if (p == null) {
            p = (Properties)ClassUtil.newInstance(ctx.getType());
        }
        _PropertiesPatternDecoder.flattenNodeToProperties(node, p, "");
        return p;
    }

    static void flattenNodeToProperties(ONode node, Properties properties, String prefix) {
        if (node.isObject()) {
            for (Map.Entry<String, ONode> entry : node.getObject().entrySet()) {
                String key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
                _PropertiesPatternDecoder.flattenNodeToProperties(entry.getValue(), properties, key);
            }
        } else if (node.isArray()) {
            List<ONode> array = node.getArray();
            for (int i = 0; i < array.size(); ++i) {
                String key = prefix + "[" + i + "]";
                _PropertiesPatternDecoder.flattenNodeToProperties(array.get(i), properties, key);
            }
        } else {
            properties.setProperty(prefix, node.getString());
        }
    }
}

