/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.decode;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.CodecException;
import org.noear.snack4.codec.DecodeContext;
import org.noear.snack4.codec.ObjectPatternDecoder;

public class _ArrayPatternDecoder
implements ObjectPatternDecoder<Object> {
    @Override
    public boolean canDecode(Class<?> clazz) {
        return clazz.isArray();
    }

    @Override
    public Object decode(DecodeContext ctx, ONode node) {
        Class itemType = null;
        itemType = ctx.getGenericType() instanceof GenericArrayType ? (Class)((GenericArrayType)ctx.getGenericType()).getGenericComponentType() : ctx.getType().getComponentType();
        if (node.isArray()) {
            int size = node.getArray().size();
            Object array = Array.newInstance(itemType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(array, i, node.get(i).toBean(itemType));
            }
            return array;
        }
        if (node.isString()) {
            String[] strArray = node.toString().split(",");
            Object array = Array.newInstance(itemType, strArray.length);
            for (int i = 0; i < strArray.length; ++i) {
                Array.set(array, i, new ONode(ctx.getOptions(), strArray[i]).toBean(itemType));
            }
            return array;
        }
        throw new CodecException("Cannot be converted to Array: " + node);
    }
}

