/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.noear.snack4.Feature;
import org.noear.snack4.SnackException;
import org.noear.snack4.codec.CodecLib;
import org.noear.snack4.codec.ObjectCreator;
import org.noear.snack4.codec.ObjectDecoder;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.snack4.codec.ObjectPatternCreator;
import org.noear.snack4.codec.ObjectPatternDecoder;
import org.noear.snack4.codec.ObjectPatternEncoder;

public final class Options {
    public static final String DEF_TYPE_PROPERTY_NAME = "@type";
    public static final ZoneId DEF_ZONE = ZoneId.systemDefault();
    public static final TimeZone DEF_TIME_ZONE = TimeZone.getDefault();
    public static final ZoneOffset DEF_OFFSET = OffsetDateTime.now().getOffset();
    public static final Locale DEF_LOCALE = Locale.getDefault();
    public static final String DEF_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final int DEF_FEATURES = 0;
    public static final Options DEF_OPTIONS = new Options(true);
    public static final String DEF_UNSUPPORTED_HINT = "Read-only mode does not support modification.";
    private final CodecLib codecLib = CodecLib.newInstance();
    private long featuresValue = 0L;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private String writeIndent = "  ";
    private String typePropertyName = "@type";
    private ClassLoader classLoader;
    private Locale locale = DEF_LOCALE;
    private ZoneId zoneId = DEF_ZONE;
    private TimeZone timeZone = DEF_TIME_ZONE;
    private Supplier<Map> mapFactory = LinkedHashMap::new;
    private Supplier<List> listFactory = ArrayList::new;
    private final boolean readonly;

    private Options(boolean readonly) {
        this.readonly = readonly;
    }

    public Class<?> loadClass(String className) {
        try {
            if (this.classLoader == null) {
                return Class.forName(className);
            }
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new SnackException("Failed to load class: " + className, e);
        }
    }

    public boolean hasFeature(Feature feature) {
        return Feature.hasFeature(this.featuresValue, feature);
    }

    public long getFeatures() {
        return this.featuresValue;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    @Deprecated
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTypePropertyName() {
        return this.typePropertyName;
    }

    public ObjectDecoder<?> getDecoder(Class<?> clazz) {
        return this.codecLib.getDecoder(clazz);
    }

    public ObjectEncoder<?> getEncoder(Object value) {
        return this.codecLib.getEncoder(value);
    }

    public ObjectCreator<?> getCreator(Class<?> clazz) {
        return this.codecLib.getCreator(clazz);
    }

    public String getWriteIndent() {
        return this.writeIndent;
    }

    public <T> Map<String, T> createMap() {
        return this.mapFactory.get();
    }

    public <T> List<T> createList() {
        return this.listFactory.get();
    }

    public Options dateFormat(String format) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.dateFormat = format;
        return this;
    }

    public Options locale(Locale locale) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.locale = locale;
        return this;
    }

    public Options timeZone(TimeZone timeZone) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.zoneId = timeZone.toZoneId();
        this.timeZone = timeZone;
        return this;
    }

    public Options timeZone(ZoneId zoneId) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.zoneId = zoneId;
        this.timeZone = TimeZone.getTimeZone(zoneId);
        return this;
    }

    public Options writeIndent(String indent) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.writeIndent = indent;
        return this;
    }

    public Options classLoader(ClassLoader classLoader) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.classLoader = classLoader;
        return this;
    }

    public Options addFeatures(Feature ... features) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.featuresValue = Feature.addFeatures(this.featuresValue, features);
        return this;
    }

    public Options setFeatures(Feature ... features) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.featuresValue = Feature.addFeatures(0L, features);
        return this;
    }

    public Options removeFeatures(Feature ... features) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.featuresValue = Feature.removeFeatures(this.featuresValue, features);
        return this;
    }

    public <T> Options addDecoder(Class<T> type, ObjectDecoder<T> decoder) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.codecLib.addDecoder(type, decoder);
        return this;
    }

    public <T> Options addDecoder(ObjectPatternDecoder<T> decoder) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.codecLib.addDecoder(decoder);
        return this;
    }

    public <T> Options addEncoder(Class<T> type, ObjectEncoder<T> encoder) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.codecLib.addEncoder(type, encoder);
        return this;
    }

    public <T> Options addEncoder(ObjectPatternEncoder<T> encoder) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.codecLib.addEncoder(encoder);
        return this;
    }

    public <T> Options addCreator(Class<T> type, ObjectCreator<T> creator) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.codecLib.addCreator(type, creator);
        return this;
    }

    public <T> Options addCreator(ObjectPatternCreator<T> creator) {
        if (this.readonly) {
            throw new UnsupportedOperationException(DEF_UNSUPPORTED_HINT);
        }
        this.codecLib.addCreator(creator);
        return this;
    }

    public Options mapFactory(Supplier<Map> mapFactory) {
        this.mapFactory = mapFactory;
        return this;
    }

    public Options listFactory(Supplier<List> listFactory) {
        this.listFactory = listFactory;
        return this;
    }

    public static Options of(Feature ... features) {
        Options tmp = new Options(false);
        for (Feature f : features) {
            tmp.addFeatures(f);
        }
        return tmp;
    }
}

