/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.http.common.codec.h2.hpack.HPACK;

final class ISO_8859_1 {
    private ISO_8859_1() {
    }

    public static final class Writer {
        private final HPACK.BufferUpdateConsumer UPDATER = (buf, bufLen) -> {
            this.buffer = buf;
            this.bufferLen = bufLen;
        };
        private CharSequence source;
        private int pos;
        private int end;
        private long buffer;
        private int bufferLen;

        public Writer configure(CharSequence source, int start, int end) {
            this.source = source;
            this.pos = start;
            this.end = end;
            return this;
        }

        public boolean write(ByteBuffer destination) {
            while (true) {
                if (this.pos < this.end) {
                    char c = this.source.charAt(this.pos);
                    if (c > '\u00ff') {
                        throw new IllegalArgumentException(Integer.toString(c));
                    }
                    if (this.bufferLen <= 56) {
                        this.buffer |= (long)c << 56 - this.bufferLen;
                        this.bufferLen += 8;
                        ++this.pos;
                        continue;
                    }
                }
                if (this.bufferLen == 0) {
                    return true;
                }
                int nBytes = HPACK.write(this.buffer, this.bufferLen, this.UPDATER, destination);
                if (nBytes == 0) break;
            }
            return false;
        }

        public Writer reset() {
            this.source = null;
            this.pos = -1;
            this.end = -1;
            this.buffer = 0L;
            this.bufferLen = 0;
            return this;
        }
    }

    public static final class Reader {
        private final HPACK.BufferUpdateConsumer UPDATER = (buf, bufLen) -> {
            this.buffer = buf;
            this.bufferLen = bufLen;
        };
        private long buffer;
        private int bufferLen;

        public void read(ByteBuffer source, Appendable destination) throws IOException {
            int nBytes;
            block2: while ((nBytes = HPACK.read(source, this.buffer, this.bufferLen, this.UPDATER)) != 0) {
                assert (this.bufferLen % 8 == 0) : this.bufferLen;
                while (true) {
                    if (this.bufferLen <= 0) continue block2;
                    char c = (char)(this.buffer >>> 56);
                    try {
                        destination.append(c);
                    }
                    catch (IOException e) {
                        throw new IOException("Error appending to the destination", e);
                    }
                    this.buffer <<= 8;
                    this.bufferLen -= 8;
                }
                break;
            }
            return;
        }

        public Reader reset() {
            this.buffer = 0L;
            this.bufferLen = 0;
            return this;
        }
    }
}

