/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.common;

import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.noear.nami.annotation.NamiBody;
import org.noear.nami.annotation.NamiParam;
import org.noear.nami.common.TextUtils;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Body;
import org.noear.solon.annotation.Cookie;
import org.noear.solon.annotation.Header;
import org.noear.solon.annotation.Param;

public class ParameterDesc {
    private final Parameter parameter;
    private String name;
    private boolean isHeader;
    private boolean isCookie;
    private boolean isBody;

    public ParameterDesc(Parameter parameter) {
        this.parameter = parameter;
        this.resolveAnno();
        if (TextUtils.isEmpty(this.name)) {
            this.name = parameter.getName();
        }
    }

    private void resolveAnno() {
        NamiBody namiBodyAnno = this.parameter.getAnnotation(NamiBody.class);
        if (namiBodyAnno != null) {
            this.isBody = true;
            return;
        }
        NamiParam namiParamAnno = this.parameter.getAnnotation(NamiParam.class);
        if (namiParamAnno != null) {
            this.name = namiParamAnno.value();
            return;
        }
        Body bodyAnno = this.parameter.getAnnotation(Body.class);
        if (bodyAnno != null) {
            this.isBody = true;
            return;
        }
        Param paramAnno = this.parameter.getAnnotation(Param.class);
        if (paramAnno != null) {
            this.name = Utils.annoAlias((String)paramAnno.value(), (String)paramAnno.name());
            return;
        }
        Header headerAnno = this.parameter.getAnnotation(Header.class);
        if (headerAnno != null) {
            this.isHeader = true;
            this.name = Utils.annoAlias((String)headerAnno.value(), (String)headerAnno.name());
            return;
        }
        Cookie cookieAnno = this.parameter.getAnnotation(Cookie.class);
        if (cookieAnno != null) {
            this.isCookie = true;
            this.name = Utils.annoAlias((String)cookieAnno.value(), (String)cookieAnno.name());
            return;
        }
    }

    public boolean isBody() {
        return this.isBody;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public boolean isCookie() {
        return this.isCookie;
    }

    public Type getType() {
        return this.parameter.getType();
    }

    public String getName() {
        return this.name;
    }
}

