/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.common;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.nami.annotation.NamiBody;
import org.noear.nami.annotation.NamiMapping;
import org.noear.nami.common.ParameterDesc;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Consumes;
import org.noear.solon.annotation.Delete;
import org.noear.solon.annotation.Get;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Patch;
import org.noear.solon.annotation.Post;
import org.noear.solon.annotation.Put;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.UploadedFile;

public class MethodDesc {
    private static final Map<Method, MethodDesc> cached = new ConcurrentHashMap<Method, MethodDesc>();
    private final Method method;
    private final List<ParameterDesc> parameters;
    private final Map<String, String> headers;
    private String action;
    private String path;

    public static MethodDesc get(Method method) {
        MethodDesc mw = cached.computeIfAbsent(method, k -> new MethodDesc(method));
        return mw;
    }

    public Method getMethod() {
        return this.method;
    }

    public List<ParameterDesc> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getAction() {
        return this.action;
    }

    public String getPath() {
        return this.path;
    }

    protected MethodDesc(Method m) {
        this.method = m;
        this.parameters = new ArrayList<ParameterDesc>(m.getParameterCount());
        this.headers = new HashMap<String, String>();
        if (!this.resolveMethodAnnoByNamiMapping(m)) {
            this.resolveMethodAnnoByMapping(m);
        }
        this.resolveParamAnno(m);
    }

    protected boolean resolveMethodAnnoByNamiMapping(Method m) {
        NamiMapping mappingAnno = m.getAnnotation(NamiMapping.class);
        if (mappingAnno != null) {
            if (mappingAnno.value().length() > 0) {
                String val = mappingAnno.value().trim();
                int idx = val.indexOf(" ");
                if (idx > 0) {
                    this.action = val.substring(0, idx);
                    this.path = val.substring(idx + 1);
                } else {
                    this.action = val;
                }
            }
            if (mappingAnno.headers().length > 0) {
                for (String h : mappingAnno.headers()) {
                    String[] ss = h.split("=");
                    if (ss.length != 2) continue;
                    this.headers.put(ss[0].trim(), ss[1].trim());
                }
            }
        }
        return mappingAnno != null;
    }

    protected void resolveMethodAnnoByMapping(Method m) {
        Consumes anno;
        Mapping mappingAnno = m.getAnnotation(Mapping.class);
        if (mappingAnno != null) {
            if (mappingAnno.value().length() > 0) {
                if (mappingAnno.method().length > 0) {
                    this.action = mappingAnno.method()[0].name();
                }
                this.path = Utils.annoAlias((String)mappingAnno.value(), (String)mappingAnno.path());
            }
            if (mappingAnno.headers().length > 0) {
                for (String h : mappingAnno.headers()) {
                    String[] ss = h.split("=");
                    if (ss.length != 2) continue;
                    this.headers.put(ss[0].trim(), ss[1].trim());
                }
            }
        }
        if (m.isAnnotationPresent(Post.class)) {
            this.action = MethodType.POST.name();
        }
        if (m.isAnnotationPresent(Get.class)) {
            this.action = MethodType.GET.name();
        }
        if (m.isAnnotationPresent(Put.class)) {
            this.action = MethodType.PUT.name();
        }
        if (m.isAnnotationPresent(Delete.class)) {
            this.action = MethodType.DELETE.name();
        }
        if (m.isAnnotationPresent(Patch.class)) {
            this.action = MethodType.PATCH.name();
        }
        if ((anno = m.getAnnotation(Consumes.class)) != null) {
            this.headers.put("Content-Type", anno.value());
        }
    }

    protected void resolveParamAnno(Method m) {
        for (Parameter p1 : m.getParameters()) {
            NamiBody namiBodyAnno;
            ParameterDesc p1w = new ParameterDesc(p1);
            this.parameters.add(p1w);
            if (p1w.isBody() && (namiBodyAnno = p1.getAnnotation(NamiBody.class)).contentType().length() > 0) {
                this.headers.putIfAbsent("Content-Type", namiBodyAnno.contentType());
            }
            if (!File.class.isAssignableFrom(p1.getType()) && !UploadedFile.class.isAssignableFrom(p1.getType())) continue;
            this.headers.put("Content-Type", "multipart/form-data");
        }
    }
}

