/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.integration.solon;

import org.noear.nami.Filter;
import org.noear.nami.NamiBuilder;
import org.noear.nami.NamiConfiguration;
import org.noear.nami.NamiManager;
import org.noear.nami.annotation.NamiClient;
import org.noear.solon.Utils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.event.EventBus;

public final class NamiConfigurationSolon
implements NamiConfiguration {
    private NamiConfiguration custom;

    public NamiConfigurationSolon() {
        Aop.getAsyn(NamiConfiguration.class, bw -> {
            this.custom = (NamiConfiguration)bw.raw();
        });
        EventBus.subscribe(Filter.class, it -> NamiManager.reg(it));
    }

    @Override
    public void config(NamiClient client, NamiBuilder builder) {
        LoadBalance upstream;
        if (Utils.isEmpty((String)client.name())) {
            return;
        }
        if (this.custom != null) {
            this.custom.config(client, builder);
        }
        if ((upstream = this.getUpstream(client)) != null) {
            builder.upstream(() -> ((LoadBalance)upstream).getServer());
        } else {
            Aop.getAsyn((String)client.name(), bw -> {
                LoadBalance tmp = (LoadBalance)bw.raw();
                builder.upstream(() -> ((LoadBalance)tmp).getServer());
            });
        }
    }

    private LoadBalance getUpstream(NamiClient anno) {
        if (Bridge.upstreamFactory() == null) {
            return null;
        }
        return Bridge.upstreamFactory().create(anno.group(), anno.name());
    }
}

