/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.integration.springboot;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.nami.Nami;
import org.noear.nami.NamiException;
import org.noear.nami.annotation.NamiClient;
import org.noear.nami.common.InfoUtils;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.extend.springboot.EnableSolon;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;

@EnableSolon
@Configuration
public class AutoConfigurationNami
extends InstantiationAwareBeanPostProcessorAdapter {
    private Map<NamiClient, Object> cached = new ConcurrentHashMap<NamiClient, Object>();

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!beanName.startsWith("org.springframework")) {
            try {
                Class<?> beanClz = bean.getClass();
                ReflectionUtils.doWithFields(beanClz, field -> {
                    if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return;
                    }
                    NamiClient client = field.getAnnotation(NamiClient.class);
                    if (client != null && field.getType().isInterface()) {
                        field.setAccessible(true);
                        field.set(bean, this.postAnno(client, field));
                    }
                });
            }
            catch (Throwable ex) {
                EventBus.push((Object)ex);
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object postAnno(NamiClient anno, Field field) {
        NamiClient anno2;
        if (Utils.isEmpty((String)anno.url()) && Utils.isEmpty((String)anno.name()) && (anno2 = field.getType().getAnnotation(NamiClient.class)) != null) {
            anno = anno2;
        }
        if (Utils.isEmpty((String)anno.url()) && Utils.isEmpty((String)anno.name()) && anno.upstream().length == 0) {
            throw new NamiException("@NamiClient configuration error!");
        }
        InfoUtils.print(field.getType(), anno);
        Object obj = this.cached.get(anno);
        if (obj == null) {
            NamiClient namiClient = anno;
            synchronized (namiClient) {
                obj = this.cached.get(anno);
                if (obj == null) {
                    obj = Nami.builder().create(field.getType(), anno);
                    this.cached.putIfAbsent(anno, obj);
                }
            }
        }
        return obj;
    }
}

