/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.nami.Nami;
import org.noear.nami.NamiConfig;
import org.noear.nami.NamiConfiguration;
import org.noear.nami.NamiException;
import org.noear.nami.annotation.Mapping;
import org.noear.nami.annotation.NamiClient;
import org.noear.nami.common.MethodWrap;
import org.noear.nami.common.UpstreamFixed;

public class NamiHandler
implements InvocationHandler {
    private static Pattern pathKeyExpr = Pattern.compile("\\{([^\\\\}]+)\\}");
    private final NamiConfig config;
    private final Map<String, String> headers0 = new LinkedHashMap<String, String>();
    private final String name0;
    private final String path0;
    private final String url0;
    private final Class<?> clz0;
    private final Map<String, Map> pathKeysCached = new ConcurrentHashMap<String, Map>();
    protected MethodHandles.Lookup lookup;

    public NamiHandler(Class<?> clz, NamiConfig config, NamiClient client) {
        this.config = config;
        this.clz0 = clz;
        if (client != null) {
            try {
                NamiConfiguration tmp = client.configuration().newInstance();
                if (tmp != null) {
                    tmp.config(client, new Nami.Builder(config));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (client.headers().length > 0) {
                for (String h : client.headers()) {
                    String[] ss = h.split("=");
                    if (ss.length != 2) continue;
                    this.headers0.put(ss[0].trim(), ss[1].trim());
                }
            }
            if (client.upstream().length > 0) {
                config.setUpstream(new UpstreamFixed(Arrays.asList(client.upstream())));
            }
        }
        config.tryInit();
        String uri = config.getUri();
        if (uri == null && client != null && !NamiHandler.isEmpty(client.value())) {
            uri = client.value();
        }
        if (uri == null) {
            uri = "";
        }
        if (uri.contains("://")) {
            this.url0 = uri;
            this.name0 = null;
            this.path0 = null;
        } else if (uri.contains(":")) {
            this.url0 = null;
            this.name0 = uri.split(":")[0];
            this.path0 = uri.split(":")[1];
        } else {
            this.url0 = null;
            this.name0 = uri;
            this.path0 = null;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] vals) throws Throwable {
        Class<?> type;
        if (this.url0 == null && this.config.getUpstream() == null) {
            throw new NamiException("NamiClient: Not found upstream: " + this.clz0.getName());
        }
        MethodWrap methodWrap = MethodWrap.get(method);
        Class<?> caller = method.getDeclaringClass();
        if (Object.class == caller) {
            if (this.lookup == null) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                constructor.setAccessible(true);
                this.lookup = (MethodHandles.Lookup)constructor.newInstance(caller, 2);
            }
            return this.lookup.unreflectSpecial(method, caller).bindTo(proxy).invokeWithArguments(vals);
        }
        HashMap<String, String> headers = new HashMap<String, String>(this.headers0);
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        Object body = null;
        Parameter[] names = methodWrap.getParameters();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            if (vals[i] == null) continue;
            args.put(names[i].getName(), vals[i]);
        }
        if (methodWrap.getBodyName() != null) {
            body = args.get(methodWrap.getBodyName());
            if (this.config.getEncoder() == null) {
                headers.putIfAbsent("Content-Type", methodWrap.getBodyAnno().contentType());
            }
        }
        String fun = method.getName();
        String act = null;
        Mapping mapping = methodWrap.getMappingAnno();
        if (mapping != null) {
            if (methodWrap.getAct() != null) {
                act = methodWrap.getAct();
            }
            if (methodWrap.getFun() != null) {
                fun = methodWrap.getFun();
            }
            if (methodWrap.getMappingHeaders() != null) {
                headers.putAll(methodWrap.getMappingHeaders());
            }
        }
        String url = null;
        if (this.url0 == null) {
            url = this.config.getUpstream().get();
            if (url == null) {
                throw new NamiException("NamiClient: Not found upstream!");
            }
            if (this.path0 != null) {
                int idx = url.indexOf("/", 9);
                if (idx > 0) {
                    url = url.substring(0, idx);
                }
                fun = this.path0.endsWith("/") ? this.path0 + fun : this.path0 + "/" + fun;
            }
        } else {
            url = this.url0;
        }
        if (fun != null && fun.indexOf("{") > 0) {
            Map<String, String> pathKeys = this.buildPathKeys(fun);
            for (Map.Entry<String, String> kv : pathKeys.entrySet()) {
                String val = (String)args.get(kv.getValue());
                if (val == null) continue;
                fun = fun.replace(kv.getKey(), val);
                args.remove(kv.getValue());
            }
        }
        if ((type = method.getGenericReturnType()) == null) {
            type = method.getReturnType();
        }
        return new Nami(this.config).method(method).action(act).url(url, fun).call(headers, args, body).getObject(type);
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> buildPathKeys(String path) {
        LinkedHashMap<String, String> pathKeys = this.pathKeysCached.get(path);
        if (pathKeys == null) {
            String string = path.intern();
            synchronized (string) {
                pathKeys = this.pathKeysCached.get(path);
                if (pathKeys == null) {
                    pathKeys = new LinkedHashMap<String, String>();
                    Matcher pm = pathKeyExpr.matcher(path);
                    while (pm.find()) {
                        pathKeys.put(pm.group(), pm.group(1));
                    }
                }
            }
        }
        return pathKeys;
    }
}

