/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Filter;
import org.noear.nami.NamiChannel;
import org.noear.nami.NamiConfig;
import org.noear.nami.NamiException;
import org.noear.nami.NamiHandler;
import org.noear.nami.Result;
import org.noear.nami.annotation.NamiClient;

public class Nami {
    public static NamiChannel defaultChannel;
    public static Encoder defaultEncoder;
    public static Decoder defaultDecoder;
    private String _url;
    private String _method = "POST";
    private final NamiConfig _config;
    private Result _result;

    public Nami() {
        this._config = new NamiConfig().tryInit();
    }

    protected Nami(NamiConfig config) {
        this._config = config;
        config.tryInit();
    }

    public Nami method(String method) {
        if (method != null && method.length() > 0) {
            this._method = method;
        }
        return this;
    }

    public Nami url(String url) {
        this._url = url;
        return this;
    }

    public Nami url(String url, String fun) {
        if (url.indexOf("{fun}") > 0) {
            this._url = url.replace("{fun}", fun);
        } else if (fun == null) {
            this._url = url;
        } else {
            StringBuilder sb = new StringBuilder(200);
            sb.append(url);
            if (url.endsWith("/")) {
                if (fun.startsWith("/")) {
                    sb.append(fun.substring(1));
                } else {
                    sb.append(fun);
                }
            } else if (fun.startsWith("/")) {
                sb.append(fun);
            } else {
                sb.append("/").append(fun);
            }
            this._url = sb.toString();
        }
        return this;
    }

    public Nami call(Map<String, String> headers, Map args) {
        try {
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            if (args == null) {
                args = new HashMap<String, Object>();
            }
            for (Filter filter : this._config.getFilters()) {
                filter.filter(this._config, this._method, this._url, headers, args);
            }
            this._result = this._config.getChannel().call(this._config, this._method, this._url, headers, args);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return this;
    }

    public Result result() {
        return this._result;
    }

    public String getString() {
        return this._result.bodyAsString();
    }

    public <T> T getObject(Class<T> returnType) {
        if (Void.TYPE.equals(returnType)) {
            return null;
        }
        return this._config.getDecoder().decode(this._result, returnType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final NamiConfig _config;

        protected Builder() {
            this._config = new NamiConfig();
        }

        protected Builder(NamiConfig config) {
            this._config = config;
        }

        public Builder upstream(Supplier<String> upstream) {
            this._config.setUpstream(upstream);
            return this;
        }

        public Builder encoder(Encoder encoder) {
            this._config.setEncoder(encoder);
            return this;
        }

        public Builder decoder(Decoder decoder) {
            this._config.setDecoder(decoder);
            return this;
        }

        public Builder channel(NamiChannel channel) {
            this._config.setChannel(channel);
            return this;
        }

        public Builder filterAdd(Filter filter) {
            this._config.filterAdd(filter);
            return this;
        }

        public Builder uri(String uri) {
            this._config.setUri(uri);
            return this;
        }

        public Nami build() {
            return new Nami(this._config);
        }

        public <T> T create(Class<?> clz) {
            NamiClient client = clz.getAnnotation(NamiClient.class);
            return (T)this.create(clz, client);
        }

        public Object create(Class<?> clz, NamiClient client) {
            if (clz == null) {
                return null;
            }
            if (!clz.isInterface()) {
                throw new NamiException("FairyClient only support interfaces");
            }
            NamiHandler handler = new NamiHandler(clz, this._config, client);
            return Proxy.newProxyInstance(clz.getClassLoader(), new Class[]{clz}, (InvocationHandler)handler);
        }
    }
}

