/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.reflect.Type;
import org.noear.nami.Context;
import org.noear.nami.Decoder;
import org.noear.nami.EncoderTyped;
import org.noear.nami.Result;
import org.noear.nami.coder.jackson.TypeReferenceImp;

public class JacksonDecoder
implements Decoder {
    public static final JacksonDecoder instance = new JacksonDecoder();
    ObjectMapper mapper_type = new ObjectMapper();

    public JacksonDecoder() {
        this.mapper_type.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper_type.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper_type.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper_type.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        this.mapper_type.activateDefaultTypingAsProperty(this.mapper_type.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "@type");
        this.mapper_type.registerModule((Module)new JavaTimeModule());
        this.mapper_type.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper_type.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public String enctype() {
        return "application/json";
    }

    public <T> T decode(Result rst, Type type) {
        String str = rst.bodyAsString();
        Object returnVal = null;
        try {
            if (str == null) {
                return (T)str;
            }
            returnVal = str.contains("\"stackTrace\":[{") ? this.mapper_type.readValue(str, RuntimeException.class) : this.mapper_type.readValue(str, new TypeReferenceImp(type));
        }
        catch (Throwable ex) {
            returnVal = ex;
        }
        if (returnVal != null && returnVal instanceof Throwable) {
            if (returnVal instanceof RuntimeException) {
                throw (RuntimeException)returnVal;
            }
            throw new RuntimeException((Throwable)returnVal);
        }
        return (T)returnVal;
    }

    public void pretreatment(Context ctx) {
        if (ctx.config.getEncoder() instanceof EncoderTyped) {
            ctx.headers.put("X-Serialization", "@type_json");
        }
        ctx.headers.put("Accept", "application/json");
    }
}

