/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.reflect.Type;
import java.util.Map;
import org.noear.nami.Decoder;
import org.noear.nami.NamiConfig;
import org.noear.nami.coder.jackson.TypeReferenceImp;
import org.noear.nami.common.Result;

public class JacksonDecoder
implements Decoder {
    public static final JacksonDecoder instance = new JacksonDecoder();
    ObjectMapper mapper_type = new ObjectMapper();

    public JacksonDecoder() {
        this.mapper_type.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper_type.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper_type.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper_type.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        this.mapper_type.activateDefaultTypingAsProperty(this.mapper_type.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.OBJECT_AND_NON_CONCRETE, "@type");
    }

    public String enctype() {
        return "application/json";
    }

    public <T> T decode(Result rst, Type type) {
        String str = rst.bodyAsString();
        Object returnVal = null;
        try {
            if (str == null) {
                return (T)str;
            }
            returnVal = this.mapper_type.readValue(str, new TypeReferenceImp(type));
        }
        catch (Throwable ex) {
            returnVal = ex;
        }
        if (returnVal != null && Throwable.class.isAssignableFrom(returnVal.getClass())) {
            if (returnVal instanceof RuntimeException) {
                throw (RuntimeException)returnVal;
            }
            throw new RuntimeException((Throwable)returnVal);
        }
        return (T)returnVal;
    }

    public void filter(NamiConfig cfg, String action, String url, Map<String, String> headers, Map<String, Object> args) {
        headers.put("X-Serialization", "@type_json");
        headers.put("Accept", "application/json");
    }
}

