/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.socketd;

import java.util.Map;
import java.util.function.Supplier;
import org.noear.nami.Channel;
import org.noear.nami.ChannelBase;
import org.noear.nami.Context;
import org.noear.nami.Encoder;
import org.noear.nami.NamiManager;
import org.noear.nami.Result;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.entity.EntityDefault;

public class SocketdChannel
extends ChannelBase
implements Channel {
    public Supplier<Session> sessions;

    public SocketdChannel(Supplier<Session> sessions) {
        this.sessions = sessions;
    }

    public Result call(Context ctx) throws Throwable {
        this.pretreatment(ctx);
        if (ctx.config.getDecoder() == null) {
            throw new IllegalArgumentException("There is no suitable decoder");
        }
        ctx.config.getDecoder().pretreatment(ctx);
        Encoder encoder = ctx.config.getEncoder();
        if (encoder == null) {
            encoder = NamiManager.getEncoder((String)"application/json");
        }
        if (encoder == null) {
            throw new IllegalArgumentException("There is no suitable encoder");
        }
        ctx.headers.put("Content-Type", encoder.enctype());
        byte[] bytes = encoder.encode(ctx.body);
        EntityDefault request = new EntityDefault().metaMap(ctx.headers).data(bytes);
        Session session = this.sessions.get();
        Entity response = session.sendAndRequest(ctx.url, (Entity)request, (long)(ctx.config.getTimeout() * 1000));
        if (response == null) {
            return null;
        }
        Result result = new Result(200, response.dataAsBytes());
        Map map = response.metaMap();
        map.forEach((k, v) -> result.headerAdd(k, v));
        return result;
    }
}

