/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.http.okhttp;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.noear.nami.NamiException;

class HttpUtils {
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(300L, TimeUnit.SECONDS).writeTimeout(300L, TimeUnit.SECONDS).readTimeout(300L, TimeUnit.SECONDS).dispatcher(HttpUtils.dispatcher()).build();
    private Charset _charset;
    private RequestBody _body;
    private Map<String, String> _form;
    private Request.Builder _builder;

    private static final Dispatcher dispatcher() {
        Dispatcher temp = new Dispatcher();
        temp.setMaxRequests(20000);
        temp.setMaxRequestsPerHost(10000);
        return temp;
    }

    public static HttpUtils http(String url) {
        return new HttpUtils(url);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new NamiException((Throwable)ex);
        }
    }

    public HttpUtils(String url) {
        this._builder = new Request.Builder().url(url);
    }

    public HttpUtils charset(String charset) {
        this._charset = Charset.forName(charset);
        return this;
    }

    public HttpUtils headers(Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((k, v) -> {
                if (v != null) {
                    this._builder.header(k, v);
                }
            });
        }
        return this;
    }

    public HttpUtils data(Map<String, Object> data) {
        if (data != null) {
            this.tryInitForm();
            data.forEach((k, v) -> {
                if (v != null) {
                    this._form.put((String)k, v.toString());
                }
            });
        }
        return this;
    }

    public HttpUtils data(String key, String value) {
        this.tryInitForm();
        this._form.put(key, value);
        return this;
    }

    public HttpUtils bodyRaw(byte[] bytes, String contentType) {
        this._body = FormBody.create((MediaType)MediaType.parse((String)contentType), (byte[])bytes);
        return this;
    }

    public Response exec(String mothod) throws Exception {
        if (this._form != null) {
            String fb = new FormBody.Builder(this._charset);
            this._form.forEach((arg_0, arg_1) -> HttpUtils.lambda$exec$2((FormBody.Builder)fb, arg_0, arg_1));
            this._body = fb.build();
        }
        switch (mothod.toUpperCase()) {
            case "GET": {
                this._builder.method("GET", null);
                break;
            }
            case "POST": {
                this._builder.method("POST", this._body);
                break;
            }
            case "PUT": {
                this._builder.method("PUT", this._body);
                break;
            }
            case "DELETE": {
                this._builder.method("DELETE", this._body);
                break;
            }
            case "PATCH": {
                this._builder.method("PATCH", this._body);
                break;
            }
            case "HEAD": {
                this._builder.method("HEAD", null);
                break;
            }
            case "OPTIONS": {
                this._builder.method("OPTIONS", null);
                break;
            }
            case "TRACE": {
                this._builder.method("TRACE", null);
                break;
            }
            default: {
                throw new RuntimeException("This method is not supported");
            }
        }
        Call call = httpClient.newCall(this._builder.build());
        return call.execute();
    }

    private void tryInitForm() {
        if (this._form == null) {
            this._form = new HashMap<String, String>();
        }
    }

    private static /* synthetic */ void lambda$exec$2(FormBody.Builder fb, String k, String v) {
        fb.add(k, v);
    }
}

