/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.noear.nami.Context;
import org.noear.nami.Decoder;
import org.noear.nami.EncoderTyped;
import org.noear.nami.Result;
import org.noear.nami.coder.jackson.TypeReferenceImp;
import org.noear.nami.coder.jackson.impl.TimeDeserializer;
import org.noear.solon.Utils;

public class JacksonDecoder
implements Decoder {
    public static final JacksonDecoder instance = new JacksonDecoder();
    private ObjectMapper mapper_type;
    private SimpleModule configModule = new SimpleModule();

    public JacksonDecoder() {
        this.mapper_type = this.newMapper(new Module[]{new JavaTimeModule()});
        this.addDeserializer(LocalDateTime.class, new TimeDeserializer<LocalDateTime>(LocalDateTime.class));
        this.addDeserializer(LocalDate.class, new TimeDeserializer<LocalDate>(LocalDate.class));
        this.addDeserializer(LocalTime.class, new TimeDeserializer<LocalTime>(LocalTime.class));
        this.addDeserializer(Date.class, new TimeDeserializer<Date>(Date.class));
        this.mapper_type.registerModule((Module)this.configModule);
    }

    public ObjectMapper newMapper(Module ... modules) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.activateDefaultTypingAsProperty(mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "@type");
        mapper.registerModules(modules);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return mapper;
    }

    public <T> void addDeserializer(Class<T> clz, JsonDeserializer<? extends T> deser) {
        this.configModule.addDeserializer(clz, deser);
    }

    public String enctype() {
        return "application/json";
    }

    public <T> T decode(Result rst, Type type) throws Exception {
        if (rst.body().length == 0) {
            return null;
        }
        String str = rst.bodyAsString();
        if ("null".equals(str)) {
            return null;
        }
        if (str.contains("\"stackTrace\":[{")) {
            return (T)this.mapper_type.readValue(str, RuntimeException.class);
        }
        if (String.class == type && Utils.isNotEmpty((String)str) && str.charAt(0) != '\'' && str.charAt(0) != '\"') {
            return (T)str;
        }
        return (T)this.mapper_type.readValue(str, new TypeReferenceImp(type));
    }

    public void pretreatment(Context ctx) {
        if (ctx.config.getEncoder() instanceof EncoderTyped) {
            ctx.headers.put("X-Serialization", "@type_json");
        }
        ctx.headers.put("Accept", "application/json");
    }
}

