/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.http;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.noear.nami.Channel;
import org.noear.nami.ChannelBase;
import org.noear.nami.Context;
import org.noear.nami.Encoder;
import org.noear.nami.NamiException;
import org.noear.nami.NamiManager;
import org.noear.nami.Result;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;

public class HttpChannel
extends ChannelBase
implements Channel {
    public static final HttpChannel instance = new HttpChannel();

    public Result call(Context ctx) throws Throwable {
        this.pretreatment(ctx);
        boolean is_get = "GET".equals(ctx.action);
        String url = ctx.url;
        if (is_get && ctx.args.size() > 0 || ctx.body != null && ctx.args.size() > 0) {
            StringBuilder sb = new StringBuilder(ctx.url);
            sb.append(ctx.url.contains("?") ? "&" : "?");
            for (Map.Entry kv : ctx.args.entrySet()) {
                if (kv.getValue() == null) continue;
                sb.append((String)kv.getKey()).append('=').append(HttpUtils.urlEncode((String)kv.getValue().toString())).append('&');
            }
            url = sb.substring(0, sb.length() - 1);
        }
        if (ctx.config.getDecoder() == null) {
            throw new IllegalArgumentException("There is no suitable decoder");
        }
        ctx.config.getDecoder().pretreatment(ctx);
        HttpUtils http = HttpUtils.http((String)url).headers(ctx.headers).timeout(ctx.config.getTimeout());
        HttpResponse response = null;
        if (is_get) {
            response = http.exec("GET");
        } else {
            String contentType = ctx.headers.getOrDefault("Content-Type", "");
            if (contentType.length() > 0 && (contentType.startsWith("multipart/form-data") || contentType.startsWith("application/x-www-form-urlencoded"))) {
                response = this.formRequest(ctx, http);
            } else {
                Object encoder = null;
                if (contentType.length() > 0) {
                    encoder = NamiManager.getEncoder((String)contentType);
                }
                if (encoder == null) {
                    encoder = ctx.config.getEncoder();
                }
                if (encoder != null && encoder.bodyRequired() && ctx.body == null) {
                    throw new NamiException("The encoder requires parameters with '@NamiBody'");
                }
                response = ctx.body != null || encoder != null ? this.bodyRequest(ctx, http, (Encoder)encoder) : this.formRequest(ctx, http);
            }
        }
        if (response == null) {
            return null;
        }
        Result result = new Result(response.code(), response.bodyAsBytes());
        for (String name : response.headerNames()) {
            for (String v : response.headers(name)) {
                result.headerAdd(name, v);
            }
        }
        Charset contentEncoding = response.contentCharset();
        if (contentEncoding != null) {
            result.charsetSet(contentEncoding);
        }
        return result;
    }

    protected HttpResponse bodyRequest(Context ctx, HttpUtils http, Encoder encoder) throws Throwable {
        if (encoder == null) {
            encoder = ctx.config.getEncoderOrDefault();
        }
        if (encoder == null) {
            throw new IllegalArgumentException("Missing suitable encoder");
        }
        byte[] bytes = encoder.encode(ctx.bodyOrArgs());
        if (bytes != null) {
            return http.body(bytes, encoder.enctype()).exec(ctx.action);
        }
        return null;
    }

    protected HttpResponse formRequest(Context ctx, HttpUtils http) throws Throwable {
        for (Map.Entry kv : ctx.args.entrySet()) {
            if (kv.getValue() instanceof File) {
                http.data((String)kv.getKey(), (File)kv.getValue());
                continue;
            }
            if (kv.getValue() instanceof UploadedFile) {
                UploadedFile uploadedFile = (UploadedFile)kv.getValue();
                http.data((String)kv.getKey(), uploadedFile.getName(), uploadedFile.getContent(), uploadedFile.getContentType());
                continue;
            }
            if (kv.getValue() instanceof Collection) {
                Collection col = (Collection)kv.getValue();
                for (Object val : col) {
                    http.data((String)kv.getKey(), String.valueOf(val));
                }
                continue;
            }
            http.data((String)kv.getKey(), String.valueOf(kv.getValue()));
        }
        return http.exec(ctx.action);
    }
}

